/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.packet;

import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.entity.EntityB2Spirit;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityLaptop;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record LaptopEngagePacket(BlockPos tpos, BlockPos lpos, boolean carpet) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, LaptopEngagePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, LaptopEngagePacket::tpos, (StreamCodec)BlockPos.STREAM_CODEC, LaptopEngagePacket::lpos, (StreamCodec)ByteBufCodecs.BOOL, LaptopEngagePacket::carpet, LaptopEngagePacket::new);
    public static final CustomPacketPayload.Type<LaptopEngagePacket> PACKET_TYPE = new CustomPacketPayload.Type(RRIdentifiers.create("laptopengage"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public static void onMessage(LaptopEngagePacket m, IPayloadContext context) {
        Player player = context.player();
        Level world = player.level();
        context.enqueueWork(() -> {
            BlockEntity te;
            if (player.distanceToSqr((double)m.lpos.getX(), (double)m.lpos.getY(), (double)m.lpos.getZ()) < 100.0 && (te = world.getBlockEntity(m.lpos)) instanceof TileEntityLaptop) {
                int zz;
                int xx;
                int ZZ;
                int XX;
                TileEntityLaptop tel = (TileEntityLaptop)te;
                if (!m.carpet && tel.b2spirit > 0) {
                    XX = 11;
                    ZZ = 10;
                    if (tel.rrteam == RivalRebelsTeam.OMEGA) {
                        XX = m.tpos.getX() - RivalRebels.round.omegaData.objPos().getX();
                        ZZ = m.tpos.getZ() - RivalRebels.round.omegaData.objPos().getZ();
                    }
                    if (tel.rrteam == RivalRebelsTeam.SIGMA) {
                        XX = m.tpos.getX() - RivalRebels.round.sigmaData.objPos().getX();
                        ZZ = m.tpos.getZ() - RivalRebels.round.sigmaData.objPos().getZ();
                    }
                    if ((xx = m.tpos.getX() - m.lpos.getX()) * xx + (zz = m.tpos.getZ() - m.lpos.getZ()) * zz > 625 && XX * XX + ZZ * ZZ > 200) {
                        --tel.b2spirit;
                        world.addFreshEntity((Entity)new EntityB2Spirit(world, m.tpos.getX(), m.tpos.getY(), m.tpos.getZ(), player.getX(), player.getY(), player.getZ(), false, player.isShiftKeyDown()));
                    }
                }
                if (m.carpet && tel.b2carpet > 0) {
                    XX = 11;
                    ZZ = 10;
                    xx = m.tpos.getX() - m.lpos.getX();
                    if (xx * xx + (zz = m.tpos.getZ() - m.lpos.getZ()) * zz > 625 && XX * XX + ZZ * ZZ > 200) {
                        --tel.b2carpet;
                        world.addFreshEntity((Entity)new EntityB2Spirit(world, m.tpos.getX(), m.tpos.getY(), m.tpos.getZ(), player.getX(), player.getY(), player.getZ(), true, false));
                    }
                }
            }
        });
    }
}

