/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.packet;

import io.github.kadir1243.rivalrebels.client.gui.GuiReactor;
import io.github.kadir1243.rivalrebels.common.packet.GuiSpawnPacket;
import io.github.kadir1243.rivalrebels.common.packet.ItemUpdate;
import io.github.kadir1243.rivalrebels.common.packet.JoinTeamPacket;
import io.github.kadir1243.rivalrebels.common.packet.LaptopEngagePacket;
import io.github.kadir1243.rivalrebels.common.packet.LaptopPressPacket;
import io.github.kadir1243.rivalrebels.common.packet.ReactorMachinesPacket;
import io.github.kadir1243.rivalrebels.common.packet.ReactorStatePacket;
import io.github.kadir1243.rivalrebels.common.packet.ResetPacket;
import io.github.kadir1243.rivalrebels.common.packet.RhodesJumpPacket;
import io.github.kadir1243.rivalrebels.common.packet.RhodesPacket;
import io.github.kadir1243.rivalrebels.common.packet.VotePacket;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsPlayerList;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsRound;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityLaptop;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PacketDispatcher {
    public static void init(IEventBus bus) {
        bus.addListener(PacketDispatcher::registerPayloads);
    }

    private static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(ItemUpdate.TYPE, ItemUpdate.STREAM_CODEC, ItemUpdate::onMessage);
        registrar.playToServer(JoinTeamPacket.PACKET_TYPE, JoinTeamPacket.STREAM_CODEC, JoinTeamPacket::onMessage);
        registrar.playToServer(ResetPacket.PACKET_TYPE, ResetPacket.STREAM_CODEC, ResetPacket::onMessage);
        registrar.playToServer(VotePacket.PACKET_TYPE, VotePacket.STREAM_CODEC, VotePacket::onMessage);
        registrar.playToServer(LaptopEngagePacket.PACKET_TYPE, LaptopEngagePacket.STREAM_CODEC, LaptopEngagePacket::onMessage);
        registrar.playToServer(RhodesJumpPacket.PACKET_TYPE, RhodesJumpPacket.STREAM_CODEC, RhodesJumpPacket::onMessage);
        registrar.playToServer(LaptopPressPacket.TYPE, LaptopPressPacket.STREAM_CODEC, (payload, context) -> context.player().level().getBlockEntity(payload.pos(), (BlockEntityType)RRTileEntities.LAPTOP.get()).ifPresent(TileEntityLaptop::onGoButtonPressed));
        registrar.playToServer(ReactorStatePacket.TYPE, ReactorStatePacket.STREAM_CODEC, (payload, context) -> context.player().level().getBlockEntity(payload.pos(), (BlockEntityType)RRTileEntities.REACTOR.get()).ifPresent(tileEntityReactor -> {
            if (payload.packetType() == ReactorStatePacket.Type.EJECT_CORE) {
                tileEntityReactor.ejectCore();
            } else if (payload.packetType() == ReactorStatePacket.Type.TOGGLE_ON) {
                tileEntityReactor.toggleOn();
            }
        }));
        registrar.playToClient(GuiSpawnPacket.TYPE, GuiSpawnPacket.STREAM_CODEC, GuiSpawnPacket::onMessage);
        registrar.playToClient(RhodesPacket.PACKET_TYPE, RhodesPacket.STREAM_CODEC, RhodesPacket::onMessage);
        registrar.playToClient(RivalRebelsPlayerList.PACKET_TYPE, RivalRebelsPlayerList.STREAM_CODEC, RivalRebelsPlayerList::onMessage);
        registrar.playToClient(RivalRebelsRound.PACKET_TYPE, RivalRebelsRound.STREAM_CODEC, RivalRebelsRound::onMessage);
        registrar.playBidirectional(ReactorMachinesPacket.TYPE, ReactorMachinesPacket.STREAM_CODEC, (payload, context) -> context.player().level().getBlockEntity(payload.reactorPos(), (BlockEntityType)RRTileEntities.REACTOR.get()).ifPresent(tileEntityReactor -> {
            tileEntityReactor.entries.clear();
            for (ReactorMachinesPacket.MachineEntry machine : payload.machines()) {
                tileEntityReactor.entries.put(machine.pos(), machine);
            }
        }), GuiReactor::onMachinesPacket);
    }
}

