/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.packet;

import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RhodesPacket
implements CustomPacketPayload {
    public static final StreamCodec<FriendlyByteBuf, RhodesPacket> STREAM_CODEC = StreamCodec.ofMember(RhodesPacket::write, RhodesPacket::fromBytes);
    public static final CustomPacketPayload.Type<RhodesPacket> PACKET_TYPE = new CustomPacketPayload.Type(RRIdentifiers.create("rhodes_packet"));
    public float bodyyaw;
    int id = 0;
    float headpitch = 0.0f;
    float leftarmyaw = 0.0f;
    float leftarmpitch = 0.0f;
    float rightarmyaw = 0.0f;
    float rightarmpitch = 0.0f;
    float leftthighpitch = 0.0f;
    float rightthighpitch = 0.0f;
    float leftshinpitch = 0.0f;
    float rightshinpitch = 0.0f;
    int riderid;
    int pass1id;
    int pass2id;

    public RhodesPacket() {
    }

    public RhodesPacket(EntityRhodes er) {
        this.id = er.getId();
        this.bodyyaw = er.bodyyaw;
        this.headpitch = er.headpitch;
        this.leftarmyaw = er.leftarmyaw;
        this.leftarmpitch = er.leftarmpitch;
        this.rightarmyaw = er.rightarmyaw;
        this.rightarmpitch = er.rightarmpitch;
        this.leftthighpitch = er.leftthighpitch;
        this.rightthighpitch = er.rightthighpitch;
        this.leftshinpitch = er.leftshinpitch;
        this.rightshinpitch = er.rightshinpitch;
        this.riderid = er.rider != null ? er.rider.getId() : -1;
        this.pass1id = er.passenger1 != null ? er.passenger1.getId() : -1;
        this.pass2id = er.passenger2 != null ? er.passenger2.getId() : -1;
    }

    public static RhodesPacket fromBytes(FriendlyByteBuf buf) {
        RhodesPacket packet = new RhodesPacket();
        packet.id = buf.readInt();
        packet.bodyyaw = buf.readFloat();
        packet.headpitch = buf.readFloat();
        packet.leftarmyaw = buf.readFloat();
        packet.leftarmpitch = buf.readFloat();
        packet.rightarmyaw = buf.readFloat();
        packet.rightarmpitch = buf.readFloat();
        packet.leftthighpitch = buf.readFloat();
        packet.rightthighpitch = buf.readFloat();
        packet.leftshinpitch = buf.readFloat();
        packet.rightshinpitch = buf.readFloat();
        packet.riderid = buf.readInt();
        packet.pass1id = buf.readInt();
        packet.pass2id = buf.readInt();
        return packet;
    }

    public static void onMessage(RhodesPacket m, IPayloadContext context) {
        Entity e = context.player().level().getEntity(m.id);
        if (e instanceof EntityRhodes) {
            EntityRhodes er = (EntityRhodes)e;
            er.lastbodyyaw = er.bodyyaw;
            er.lastheadpitch = er.headpitch;
            er.lastleftarmyaw = er.leftarmyaw;
            er.lastleftarmpitch = er.leftarmpitch;
            er.lastrightarmyaw = er.rightarmyaw;
            er.lastrightarmpitch = er.rightarmpitch;
            er.lastleftthighpitch = er.leftthighpitch;
            er.lastrightthighpitch = er.rightthighpitch;
            er.lastleftshinpitch = er.leftshinpitch;
            er.lastrightshinpitch = er.rightshinpitch;
            if (Mth.abs((float)(er.bodyyaw - m.bodyyaw)) > 90.0f) {
                er.lastbodyyaw = m.bodyyaw;
            }
            if (Mth.abs((float)(er.rightarmyaw - m.rightarmyaw)) > 90.0f) {
                er.lastrightarmyaw = m.rightarmyaw;
            }
            if (Mth.abs((float)(er.leftarmyaw - m.leftarmyaw)) > 90.0f) {
                er.lastleftarmyaw = m.leftarmyaw;
            }
            er.bodyyaw = m.bodyyaw;
            er.headpitch = m.headpitch;
            er.leftarmyaw = m.leftarmyaw;
            er.leftarmpitch = m.leftarmpitch;
            er.rightarmyaw = m.rightarmyaw;
            er.rightarmpitch = m.rightarmpitch;
            er.leftthighpitch = m.leftthighpitch;
            er.rightthighpitch = m.rightthighpitch;
            er.leftshinpitch = m.leftshinpitch;
            er.rightshinpitch = m.rightshinpitch;
            er.ticksSinceLastPacket = 0;
            if (er.getHealth() <= 0.0f && er.rider != null) {
                er.rider.setPos(er.getX() + 5.0, er.getY() - 12.0, er.getZ());
                er.rider.getAbilities().invulnerable = false;
                er.rider = null;
            } else {
                er.rider = m.riderid == -1 ? null : (Player)er.level().getEntity(m.riderid);
                er.passenger1 = m.pass1id == -1 ? null : (Player)er.level().getEntity(m.pass1id);
                er.passenger2 = m.pass2id == -1 ? null : (Player)er.level().getEntity(m.pass2id);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeFloat(this.bodyyaw);
        buf.writeFloat(this.headpitch);
        buf.writeFloat(this.leftarmyaw);
        buf.writeFloat(this.leftarmpitch);
        buf.writeFloat(this.rightarmyaw);
        buf.writeFloat(this.rightarmpitch);
        buf.writeFloat(this.leftthighpitch);
        buf.writeFloat(this.rightthighpitch);
        buf.writeFloat(this.leftshinpitch);
        buf.writeFloat(this.rightshinpitch);
        buf.writeInt(this.riderid);
        buf.writeInt(this.pass1id);
        buf.writeInt(this.pass2id);
    }
}

