/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.round;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import io.github.kadir1243.rivalrebels.client.renderhelper.RRTextures;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;

public enum RivalRebelsClass implements StringRepresentable
{
    NONE(0, 0xFFFFFF, "NONE", () -> RRTextures.guitrivalrebels),
    REBEL(1, 0xFF0000, "REBEL", () -> RRTextures.guitrebel),
    NUKER(2, 0xFFFF00, "NUKER", () -> RRTextures.guitnuker),
    INTEL(3, 65467, "INTEL", () -> RRTextures.guitintel),
    HACKER(4, 65280, "HACKER", () -> RRTextures.guithacker);

    public static final Codec<RivalRebelsClass> CODEC;
    public static final StreamCodec<ByteBuf, RivalRebelsClass> STREAM_CODEC;
    private final Supplier<ItemStack[]> inventory;
    public final Supplier<RRTextures.Texture> resource;
    public final String name;
    public final int color;
    public final int id;
    private final Translations.TranslationKey translationKey;

    private RivalRebelsClass(int id, int color, String name, Supplier<RRTextures.Texture> resource) {
        this.id = id;
        this.color = color;
        this.name = name;
        this.resource = resource;
        this.inventory = Suppliers.memoize(((Supplier<ItemStack[]>)RivalRebelsClass.getItems(this))::get);
        this.translationKey = new Translations.TranslationKey("class." + name);
    }

    public List<ItemStack> getInventory() {
        return Arrays.asList(this.inventory.get());
    }

    public Translations.TranslationKey getDescription() {
        return this.translationKey.getSubKey("description");
    }

    public Translations.TranslationKey getMiniDescription() {
        return this.translationKey.getSubKey("minidesc");
    }

    public String getSerializedName() {
        return this.name;
    }

    private static Supplier<ItemStack[]> getItems(RivalRebelsClass playerClass) {
        return () -> {
            ItemStack[] itemStackArray;
            switch (playerClass.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    itemStackArray = new ItemStack[]{};
                    break;
                }
                case 3: {
                    ItemStack[] itemStackArray2 = new ItemStack[19];
                    itemStackArray2[0] = RRItems.tesla.toStack();
                    itemStackArray2[1] = RRItems.safepill.toStack(3);
                    itemStackArray2[2] = RRItems.roddisk.toStack();
                    itemStackArray2[3] = RRItems.pliers.toStack();
                    itemStackArray2[4] = RRItems.armyshovel.toStack();
                    itemStackArray2[5] = RRItems.knife.toStack(5);
                    itemStackArray2[6] = RRItems.gasgrenade.toStack(6);
                    itemStackArray2[7] = RRItems.chip.toStack();
                    itemStackArray2[8] = RRItems.remote.toStack();
                    itemStackArray2[9] = new ItemStack(RRBlocks.remotecharge, 8);
                    itemStackArray2[10] = RRBlocks.barricade.toStack(2);
                    itemStackArray2[11] = RRBlocks.tower.toStack(4);
                    itemStackArray2[12] = RRBlocks.quicksandtrap.toStack(4);
                    itemStackArray2[13] = RRBlocks.mariotrap.toStack(4);
                    itemStackArray2[14] = RRBlocks.minetrap.toStack(4);
                    itemStackArray2[15] = RRItems.battery.toStack(64);
                    itemStackArray2[16] = RRItems.battery.toStack(64);
                    itemStackArray2[17] = new ItemStack(RRBlocks.steel, 16);
                    itemStackArray = itemStackArray2;
                    itemStackArray2[18] = new ItemStack(RRBlocks.jump, 8);
                    break;
                }
                case 1: {
                    ItemStack[] itemStackArray3 = new ItemStack[18];
                    itemStackArray3[0] = RRItems.rpg.toStack();
                    itemStackArray3[1] = RRItems.einsten.toStack();
                    itemStackArray3[2] = RRItems.expill.toStack(3);
                    itemStackArray3[3] = RRItems.roddisk.toStack();
                    itemStackArray3[4] = RRItems.pliers.toStack();
                    itemStackArray3[5] = RRItems.armyshovel.toStack();
                    itemStackArray3[6] = RRItems.knife.toStack(5);
                    itemStackArray3[7] = RRItems.gasgrenade.toStack(6);
                    itemStackArray3[8] = RRItems.chip.toStack();
                    itemStackArray3[9] = RRBlocks.tower.toStack(2);
                    itemStackArray3[10] = RRBlocks.barricade.toStack(2);
                    itemStackArray3[11] = RRBlocks.quicksandtrap.toStack(2);
                    itemStackArray3[12] = RRBlocks.explosives.toStack();
                    itemStackArray3[13] = RRBlocks.bunker.toStack();
                    itemStackArray3[14] = RRItems.rocket.toStack(64);
                    itemStackArray3[15] = RRItems.redrod.toStack();
                    itemStackArray3[16] = RRItems.redrod.toStack();
                    itemStackArray = itemStackArray3;
                    itemStackArray3[17] = new ItemStack(RRBlocks.jump, 4);
                    break;
                }
                case 2: {
                    ItemStack[] itemStackArray4 = new ItemStack[16];
                    itemStackArray4[0] = RRItems.flamethrower.toStack();
                    itemStackArray4[1] = RRItems.safepill.toStack(3);
                    itemStackArray4[2] = RRItems.roddisk.toStack();
                    itemStackArray4[3] = RRItems.pliers.toStack();
                    itemStackArray4[4] = RRItems.armyshovel.toStack();
                    itemStackArray4[5] = RRItems.chip.toStack();
                    itemStackArray4[6] = RRBlocks.loader.toStack();
                    itemStackArray4[7] = RRBlocks.bunker.toStack(2);
                    itemStackArray4[8] = RRBlocks.minetrap.toStack(2);
                    itemStackArray4[9] = RRBlocks.nukeCrateTop.toStack();
                    itemStackArray4[10] = RRBlocks.nukeCrateBottom.toStack();
                    itemStackArray4[11] = RRItems.NUCLEAR_ROD.toStack();
                    itemStackArray4[12] = new ItemStack(RRBlocks.explosives, 2);
                    itemStackArray4[13] = new ItemStack(RRBlocks.tower, 2);
                    itemStackArray4[14] = RRItems.fuel.toStack(64);
                    itemStackArray = itemStackArray4;
                    itemStackArray4[15] = RRBlocks.jump.toStack(4);
                    break;
                }
                case 4: {
                    ItemStack[] itemStackArray5 = new ItemStack[19];
                    itemStackArray5[0] = RRItems.plasmacannon.toStack();
                    itemStackArray5[1] = RRItems.expill.toStack(3);
                    itemStackArray5[2] = RRItems.roddisk.toStack();
                    itemStackArray5[3] = RRItems.pliers.toStack();
                    itemStackArray5[4] = RRItems.armyshovel.toStack();
                    itemStackArray5[5] = RRItems.chip.toStack();
                    itemStackArray5[6] = RRBlocks.loader.toStack();
                    itemStackArray5[7] = RRBlocks.breadbox.toStack();
                    itemStackArray5[8] = RRItems.fuse.toStack();
                    itemStackArray5[9] = RRItems.antenna.toStack();
                    itemStackArray5[10] = new ItemStack(RRBlocks.bastion, 4);
                    itemStackArray5[11] = new ItemStack(RRBlocks.barricade, 4);
                    itemStackArray5[12] = new ItemStack(RRBlocks.bunker, 4);
                    itemStackArray5[13] = new ItemStack(RRBlocks.ammunition, 3);
                    itemStackArray5[14] = RRItems.hydrod.toStack();
                    itemStackArray5[15] = new ItemStack(RRBlocks.quicksandtrap, 4);
                    itemStackArray5[16] = new ItemStack(RRBlocks.mariotrap, 4);
                    itemStackArray5[17] = new ItemStack(RRBlocks.steel, 32);
                    itemStackArray = itemStackArray5;
                    itemStackArray5[18] = new ItemStack(RRBlocks.jump, 8);
                }
            }
            return itemStackArray;
        };
    }

    static {
        CODEC = StringRepresentable.fromValues(RivalRebelsClass::values);
        STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

