/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.round;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsClass;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsRank;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;

public class RivalRebelsPlayer {
    public static final Codec<RivalRebelsPlayer> CODEC = RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.GAME_PROFILE.fieldOf("profile").forGetter(RivalRebelsPlayer::getProfile), (App)RivalRebelsTeam.CODEC.fieldOf("team").forGetter(RivalRebelsPlayer::getTeam), (App)RivalRebelsClass.CODEC.fieldOf("fight_class").forGetter(RivalRebelsPlayer::getFightClass), (App)RivalRebelsRank.CODEC.fieldOf("rank").forGetter(RivalRebelsPlayer::getRank), (App)Codec.INT.fieldOf("resets").forGetter(RivalRebelsPlayer::getResets), (App)Codec.BOOL.fieldOf("is_reset").forGetter(RivalRebelsPlayer::isReset)).apply((Applicative)i, RivalRebelsPlayer::new));
    public static final StreamCodec<FriendlyByteBuf, RivalRebelsPlayer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.GAME_PROFILE, RivalRebelsPlayer::getProfile, RivalRebelsTeam.STREAM_CODEC, RivalRebelsPlayer::getTeam, RivalRebelsClass.STREAM_CODEC, RivalRebelsPlayer::getFightClass, RivalRebelsRank.STREAM_CODEC, RivalRebelsPlayer::getRank, (StreamCodec)ByteBufCodecs.INT, RivalRebelsPlayer::getResets, (StreamCodec)ByteBufCodecs.BOOL, RivalRebelsPlayer::isReset, RivalRebelsPlayer::new);
    public GameProfile profile;
    public RivalRebelsClass rrclass;
    public RivalRebelsTeam rrteam;
    public RivalRebelsRank rrrank;
    public int resets;
    public boolean isreset;
    public boolean voted;

    public RivalRebelsPlayer(GameProfile profile, int resets) {
        this(profile, RivalRebelsTeam.NONE, RivalRebelsClass.NONE, RivalRebelsRank.REGULAR, resets);
    }

    public RivalRebelsPlayer(GameProfile profile, RivalRebelsTeam rteam, RivalRebelsClass rclass, RivalRebelsRank rrank, int resets) {
        this(profile, rteam, rclass, rrank, resets, true);
    }

    public RivalRebelsPlayer(GameProfile profile, RivalRebelsTeam rteam, RivalRebelsClass rclass, RivalRebelsRank rrank, int resets, boolean isReset) {
        this.profile = profile;
        this.rrteam = rteam;
        this.rrclass = rclass;
        this.rrrank = rrank;
        this.resets = resets;
        this.isreset = isReset;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public boolean isReset() {
        return this.isreset;
    }

    public RivalRebelsClass getFightClass() {
        return this.rrclass;
    }

    public RivalRebelsRank getRank() {
        return this.rrrank;
    }

    public RivalRebelsTeam getTeam() {
        return this.rrteam;
    }

    public int getResets() {
        return this.resets;
    }

    public boolean equals(RivalRebelsPlayer o) {
        return this.profile.equals((Object)o.profile);
    }

    public UUID getId() {
        return this.profile.getId();
    }

    public String getUsername() {
        return this.profile.getName();
    }

    public void reset() {
        ++this.resets;
        this.isreset = true;
    }

    public void clear() {
        this.rrclass = RivalRebelsClass.NONE;
        this.isreset = true;
        this.resets = -1;
    }

    public void clearTeam() {
        this.rrclass = RivalRebelsClass.NONE;
        this.rrteam = RivalRebelsTeam.NONE;
        this.isreset = true;
        this.resets = -1;
    }
}

