/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.round;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsPlayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RivalRebelsPlayerList(List<RivalRebelsPlayer> players) implements CustomPacketPayload
{
    public static final Codec<RivalRebelsPlayerList> CODEC = RecordCodecBuilder.create(i -> i.group((App)RivalRebelsPlayer.CODEC.listOf().fieldOf("players").forGetter(RivalRebelsPlayerList::players)).apply((Applicative)i, RivalRebelsPlayerList::new));
    public static final StreamCodec<FriendlyByteBuf, RivalRebelsPlayerList> STREAM_CODEC = StreamCodec.composite((StreamCodec)RivalRebelsPlayer.STREAM_CODEC.apply(ByteBufCodecs.list()), RivalRebelsPlayerList::players, RivalRebelsPlayerList::new);
    public static final CustomPacketPayload.Type<RivalRebelsPlayerList> PACKET_TYPE = new CustomPacketPayload.Type(RRIdentifiers.create("rivalrebelsplayerlist"));

    public RivalRebelsPlayerList() {
        this(new ArrayList<RivalRebelsPlayer>());
    }

    public int getSize() {
        return this.players.size();
    }

    public RivalRebelsPlayer add(RivalRebelsPlayer o) {
        this.players.add(o);
        return o;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public void clear() {
        this.players.forEach(RivalRebelsPlayer::clear);
    }

    public void clearTeam() {
        this.players.forEach(RivalRebelsPlayer::clearTeam);
    }

    public boolean contains(GameProfile o) {
        return this.players.stream().map(rivalRebelsPlayer -> rivalRebelsPlayer.profile).anyMatch(gameProfile -> gameProfile.equals((Object)o));
    }

    public RivalRebelsPlayer getForGameProfile(GameProfile profile) {
        for (RivalRebelsPlayer player : this.players) {
            if (!player.profile.equals((Object)profile)) continue;
            return player;
        }
        return this.add(new RivalRebelsPlayer(profile, RRConfig.SERVER.getMaximumResets()));
    }

    public void clearVotes() {
        this.players.forEach(rivalRebelsPlayer -> {
            rivalRebelsPlayer.voted = false;
        });
    }

    public static void onMessage(RivalRebelsPlayerList m, IPayloadContext context) {
        RivalRebels.round.rrplayerlist = m;
    }

    public void refreshForWorld(Level world) {
        if (world.isClientSide()) {
            return;
        }
        for (Player player : world.players()) {
            ((ServerPlayer)player).connection.send((CustomPacketPayload)this);
        }
    }
}

