/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.round;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function9;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RRIdentifiers;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.client.gui.GuiNextBattle;
import io.github.kadir1243.rivalrebels.client.gui.GuiOmegaWin;
import io.github.kadir1243.rivalrebels.client.gui.GuiSigmaWin;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.packet.GuiSpawnPacket;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsPlayer;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsPlayerList;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import io.github.kadir1243.rivalrebels.common.round.TeamData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RivalRebelsRound
extends SavedData
implements CustomPacketPayload {
    public static final StreamCodec<FriendlyByteBuf, RivalRebelsRound> STREAM_CODEC = RivalRebelsRound.composite(ByteBufCodecs.BOOL, rivalRebelsRound -> rivalRebelsRound.roundstarted, BlockPos.STREAM_CODEC, rivalRebelsRound -> rivalRebelsRound.cSpawn, TeamData.STREAM_CODEC, rivalRebelsRound -> rivalRebelsRound.omegaData, TeamData.STREAM_CODEC, rivalRebelsRound -> rivalRebelsRound.sigmaData, ByteBufCodecs.INT, rivalRebelsRound -> rivalRebelsRound.winCountdown, RivalRebelsTeam.STREAM_CODEC, rivalRebelsRound -> rivalRebelsRound.lastWinnerTeam, ByteBufCodecs.BOOL, rivalRebelsRound -> rivalRebelsRound.fatnuke, ByteBufCodecs.STRING_UTF8, RivalRebelsRound::getMotD, RivalRebelsPlayerList.STREAM_CODEC, rivalRebelsRound -> rivalRebelsRound.rrplayerlist, RivalRebelsRound::new);
    public static final Codec<RivalRebelsRound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("roundstarted").forGetter(rivalRebelsRound -> rivalRebelsRound.roundstarted), (App)BlockPos.CODEC.fieldOf("cSpawn").forGetter(rivalRebelsRound -> rivalRebelsRound.cSpawn), (App)TeamData.CODEC.fieldOf("omegaData").forGetter(rivalRebelsRound -> rivalRebelsRound.omegaData), (App)TeamData.CODEC.fieldOf("sigmaData").forGetter(rivalRebelsRound -> rivalRebelsRound.sigmaData), (App)Codec.INT.fieldOf("winCountdown").forGetter(rivalRebelsRound -> rivalRebelsRound.winCountdown), (App)RivalRebelsTeam.CODEC.fieldOf("lastWinnerTeam").forGetter(rivalRebelsRound -> rivalRebelsRound.lastWinnerTeam), (App)Codec.BOOL.fieldOf("fatnuke").forGetter(rivalRebelsRound -> rivalRebelsRound.fatnuke), (App)Codec.STRING.fieldOf("motd").forGetter(RivalRebelsRound::getMotD), (App)RivalRebelsPlayerList.CODEC.fieldOf("rrplayerlist").forGetter(rivalRebelsRound -> rivalRebelsRound.rrplayerlist)).apply((Applicative)instance, RivalRebelsRound::new));
    private static final SavedDataType<RivalRebelsRound> WORLD_DATA_TYPE = new SavedDataType("rivalrebelsgamedata", RivalRebelsRound::new, CODEC);
    public static final CustomPacketPayload.Type<RivalRebelsRound> PACKET_TYPE = new CustomPacketPayload.Type(RRIdentifiers.create("rivalrebelsrounddata"));
    public BlockPos cSpawn;
    public TeamData omegaData;
    public TeamData sigmaData;
    private String MotD;
    public RivalRebelsPlayerList rrplayerlist;
    public Level world;
    private int winCountdown;
    private RivalRebelsTeam lastWinnerTeam;
    private boolean fatnuke;
    public int waitVotes = 0;
    public int newBattleVotes = 0;
    private int spawnRadius = 20;
    private int spawnRadius2 = 400;
    private int objRadius = 29;
    private int objRadius2 = 841;
    private int spawnDist = 150;
    private int objDist = 200;
    private boolean roundstarted;
    private final List<PlayerInvisibility> players = new ArrayList<PlayerInvisibility>();

    public RivalRebelsRound() {
        this.MotD = "Select your class and nuke the enemy team's objective to win.";
        this.cSpawn = new BlockPos(-1, -1, -1);
        this.rrplayerlist = new RivalRebelsPlayerList();
        this.lastWinnerTeam = RivalRebelsTeam.NONE;
        this.winCountdown = 0;
        this.fatnuke = false;
        this.roundstarted = false;
    }

    private RivalRebelsRound(boolean roundStarted, BlockPos cSpawn, TeamData omegaData, TeamData sigmaData, int winCountdown, RivalRebelsTeam lastWinnerTeam, boolean fatnuke, String motD, RivalRebelsPlayerList playerList) {
        this.roundstarted = roundStarted;
        this.cSpawn = cSpawn;
        this.omegaData = omegaData;
        this.sigmaData = sigmaData;
        this.winCountdown = winCountdown;
        this.lastWinnerTeam = lastWinnerTeam;
        this.fatnuke = fatnuke;
        this.MotD = motD;
        this.rrplayerlist = playerList;
    }

    public void setRoundDistances(int spawnRadius, int spawnDist, int objDist) {
        this.spawnRadius = spawnRadius;
        this.spawnRadius2 = spawnRadius * spawnRadius;
        this.spawnDist = spawnDist;
        this.objDist = objDist;
        this.omegaData = new TeamData();
        this.sigmaData = new TeamData();
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final StreamCodec<? super B, T9> codec9, final Function<C, T9> getter9, final Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, C> factory) {
        return new StreamCodec<B, C>(){

            public C decode(B buffer) {
                Object t1 = codec1.decode(buffer);
                Object t2 = codec2.decode(buffer);
                Object t3 = codec3.decode(buffer);
                Object t4 = codec4.decode(buffer);
                Object t5 = codec5.decode(buffer);
                Object t6 = codec6.decode(buffer);
                Object t7 = codec7.decode(buffer);
                Object t8 = codec8.decode(buffer);
                Object t9 = codec9.decode(buffer);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9);
            }

            public void encode(B object, C object2) {
                codec1.encode(object, getter1.apply(object2));
                codec2.encode(object, getter2.apply(object2));
                codec3.encode(object, getter3.apply(object2));
                codec4.encode(object, getter4.apply(object2));
                codec5.encode(object, getter5.apply(object2));
                codec6.encode(object, getter6.apply(object2));
                codec7.encode(object, getter7.apply(object2));
                codec8.encode(object, getter8.apply(object2));
                codec9.encode(object, getter9.apply(object2));
            }
        };
    }

    public void init(IEventBus modEventBus, Dist dist) {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(ServerTickEvent.Post.class, event -> {
            if (this.roundstarted && this.winCountdown > 0) {
                this.updateServer();
            }
        });
        eventBus.addListener(PlayerEvent.PlayerRespawnEvent.class, event -> {
            if (event.getEntity().level().isClientSide()) {
                return;
            }
            if (!this.roundstarted) {
                return;
            }
            Player player = event.getEntity();
            BlockPos pos = this.cSpawn.atY(200);
            player.setPosRaw((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            ((ServerPlayer)player).connection.send((CustomPacketPayload)GuiSpawnPacket.INSTANCE);
        });
        eventBus.addListener(PlayerEvent.PlayerLoggedInEvent.class, event -> {
            if (event.getEntity().level().isClientSide()) {
                return;
            }
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (!this.roundstarted) {
                return;
            }
            if (!this.rrplayerlist.contains(player.getGameProfile())) {
                player.getInventory().clearContent();
                BlockPos pos = this.cSpawn.atY(200);
                player.setPosRaw((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                this.rrplayerlist.add(new RivalRebelsPlayer(player.getGameProfile(), RRConfig.SERVER.getMaximumResets()));
            }
            player.connection.send((CustomPacketPayload)this.rrplayerlist);
            if (this.isInSpawn((Player)player)) {
                player.connection.send((CustomPacketPayload)GuiSpawnPacket.INSTANCE);
            }
        });
        eventBus.addListener(LevelEvent.Load.class, event -> {
            if (event.getLevel().isClientSide()) {
                return;
            }
            this.load((Level)event.getLevel());
        });
        eventBus.addListener(LevelEvent.Save.class, event -> {
            if (event.getLevel().isClientSide()) {
                return;
            }
            this.save((Level)event.getLevel());
        });
        if (dist.isClient()) {
            eventBus.addListener(ClientTickEvent.Post.class, event -> {
                if (this.roundstarted && this.winCountdown > 0) {
                    this.updateClient();
                }
            });
            eventBus.addListener(LevelTickEvent.Post.class, event -> {
                if (event.getLevel().isClientSide()) {
                    this.updateInvisible(event.getLevel());
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public static void onMessage(RivalRebelsRound m, IPayloadContext context) {
        RivalRebels.round.copy(m);
    }

    public void copy(RivalRebelsRound m) {
        this.roundstarted = m.roundstarted;
        this.cSpawn = m.cSpawn;
        this.omegaData = m.omegaData;
        this.sigmaData = m.sigmaData;
        this.winCountdown = m.winCountdown;
        this.lastWinnerTeam = m.lastWinnerTeam;
        this.MotD = m.MotD;
        this.rrplayerlist = m.rrplayerlist;
    }

    public void newRound() {
        float f;
        this.fatnuke = false;
        if (!this.roundstarted) {
            this.startRound(0, 0);
            return;
        }
        this.rrplayerlist = new RivalRebelsPlayerList();
        for (Player player : this.world.players()) {
            player.hurt(this.world.damageSources().fellOutOfWorld(), 20000.0f);
            player.getInventory().clearContent();
        }
        this.cSpawn = new BlockPos(this.cSpawn.getX(), -1, this.cSpawn.getZ() + this.spawnDist);
        if (!this.world.isClientSide()) {
            ((ServerLevel)this.world).setDefaultSpawnPos(this.cSpawn.atY(200), 0.0f);
        }
        for (f = RRConfig.SERVER.getRhodesInRoundsChance(); f >= 1.0f; f -= 1.0f) {
            this.world.addFreshEntity((Entity)new EntityRhodes(this.world, (double)this.cSpawn.getX() + this.world.random.nextDouble() - 0.5, 170.0, (double)this.cSpawn.getZ() + this.world.random.nextDouble() - 0.5, 1.0f));
        }
        if ((double)f > this.world.random.nextDouble()) {
            this.world.addFreshEntity((Entity)new EntityRhodes(this.world, (double)this.cSpawn.getX() + this.world.random.nextDouble() - 0.5, 170.0, (double)this.cSpawn.getZ() + this.world.random.nextDouble() - 0.5, 1.0f));
        }
        this.buildSpawn();
        this.omegaData.health = RRConfig.SERVER.getObjectiveHealth();
        this.sigmaData.health = RRConfig.SERVER.getObjectiveHealth();
        this.sendUpdatePacket();
    }

    public void startRound(int x, int z) {
        this.fatnuke = false;
        this.roundstarted = true;
        this.cSpawn = new BlockPos(x, -1, z - this.spawnDist);
        this.newRound();
    }

    public void roundManualStart() {
        if (!this.roundstarted || this.fatnuke) {
            this.fatnuke = true;
            this.roundstarted = true;
            this.rrplayerlist = new RivalRebelsPlayerList();
            this.cSpawn = new BlockPos((this.omegaData.objPos().getX() + this.sigmaData.objPos().getX()) / 2, -1, (this.omegaData.objPos().getZ() + this.sigmaData.objPos().getZ()) / 2);
            ((ServerLevel)this.world).setDefaultSpawnPos(this.cSpawn.atY(this.world.getChunk(this.cSpawn).getHeight()), 0.0f);
            this.omegaData.health = RRConfig.SERVER.getObjectiveHealth();
            this.sigmaData.health = RRConfig.SERVER.getObjectiveHealth();
            this.sendUpdatePacket();
        }
    }

    public void setInvisible(Player player) {
        if (player != null) {
            boolean contained = false;
            for (int i = this.players.size() - 1; i >= 0; --i) {
                PlayerInvisibility t = this.players.get(i);
                if (t.player != player) continue;
                t.durationLeft = 120;
                contained = true;
            }
            if (!contained) {
                this.players.add(new PlayerInvisibility(player, 120));
            }
        }
    }

    public void updateServer() {
        --this.winCountdown;
        if (this.winCountdown == 0 && !this.fatnuke) {
            if (this.newBattleVotes >= this.waitVotes) {
                this.newBattleVotes = 0;
                this.waitVotes = 0;
                this.rrplayerlist.clearVotes();
                this.newRound();
            } else {
                this.newBattleVotes = 0;
                this.waitVotes = 0;
                this.rrplayerlist.clearVotes();
                this.winCountdown = 1199;
                this.sendUpdatePacket();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateInvisible(Level level) {
        if (level == null) {
            return;
        }
        for (Player player : level.players()) {
            if (!player.getItemBySlot(EquipmentSlot.HEAD).is(RRItems.camera)) continue;
            this.setInvisible(player);
        }
        for (int i = this.players.size() - 1; i >= 0; --i) {
            PlayerInvisibility t = this.players.get(i);
            --t.durationLeft;
            if (t.durationLeft <= 0) {
                Entity.setViewScale((double)1.0);
                this.players.remove(i);
                continue;
            }
            Entity.setViewScale((double)0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateClient() {
        Minecraft minecraft = Minecraft.getInstance();
        --this.winCountdown;
        if (this.winCountdown == 0 && !this.fatnuke) {
            minecraft.setScreen(null);
        } else if (this.winCountdown == 400 && !this.fatnuke) {
            minecraft.setScreen((Screen)new GuiNextBattle());
        } else if (this.winCountdown == 1000) {
            minecraft.setScreen(null);
        } else if (this.winCountdown == 1200) {
            if (this.lastWinnerTeam == RivalRebelsTeam.OMEGA) {
                minecraft.setScreen((Screen)new GuiOmegaWin());
            } else if (this.lastWinnerTeam == RivalRebelsTeam.SIGMA) {
                minecraft.setScreen((Screen)new GuiSigmaWin());
            } else {
                minecraft.player.displayClientMessage((Component)Component.literal((String)"Error No Winner ?").withStyle(ChatFormatting.RED), false);
            }
        }
    }

    public void load(Level world) {
        this.world = world;
        Scoreboard scrb = this.world.getScoreboard();
        try {
            PlayerTeam omega = scrb.getPlayerTeam(RivalRebelsTeam.OMEGA.toString());
            PlayerTeam sigma = scrb.getPlayerTeam(RivalRebelsTeam.SIGMA.toString());
            if (omega == null) {
                omega = scrb.addPlayerTeam(RivalRebelsTeam.OMEGA.toString());
            }
            if (sigma == null) {
                sigma = scrb.addPlayerTeam(RivalRebelsTeam.SIGMA.toString());
            }
            omega.setPlayerPrefix((Component)Component.literal((String)"\u03a9").withStyle(ChatFormatting.GREEN));
            sigma.setPlayerPrefix((Component)Component.literal((String)"\u03a3").withStyle(ChatFormatting.BLUE));
            omega.setAllowFriendlyFire(false);
            sigma.setAllowFriendlyFire(false);
            Objective killObjective = new Objective(scrb, "kills", ObjectiveCriteria.KILL_COUNT_PLAYERS, Component.nullToEmpty((String)ObjectiveCriteria.KILL_COUNT_PLAYERS.getName()), ObjectiveCriteria.KILL_COUNT_PLAYERS.getDefaultRenderType(), true, (NumberFormat)StyledFormat.NO_STYLE);
            Objective deathObjective = new Objective(scrb, "deaths", ObjectiveCriteria.DEATH_COUNT, Component.nullToEmpty((String)ObjectiveCriteria.DEATH_COUNT.getName()), ObjectiveCriteria.DEATH_COUNT.getDefaultRenderType(), true, (NumberFormat)StyledFormat.NO_STYLE);
            scrb.setDisplayObjective(DisplaySlot.LIST, killObjective);
            for (Player player : world.players()) {
                scrb.getOrCreatePlayerScore((ScoreHolder)player, killObjective);
                ScoreAccess deaths = scrb.getOrCreatePlayerScore((ScoreHolder)player, deathObjective);
                deaths.display(Component.nullToEmpty((String)"\u00a78R\u00a77I\u00a7fV\u00a77A\u00a78L R\u00a77E\u00a7fBE\u00a77L\u00a78S"));
            }
            if (RRConfig.SERVER.isScoreboardEnabled()) {
                scrb.setDisplayObjective(DisplaySlot.SIDEBAR, deathObjective);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (world.isClientSide()) {
            return;
        }
        ((GameRules.BooleanValue)((ServerLevel)this.world).getGameRules().getRule(GameRules.RULE_KEEPINVENTORY)).set(true, world.getServer());
        ((ServerLevel)world).getDataStorage().get(WORLD_DATA_TYPE);
    }

    public void save(Level world) {
        this.world = world;
        if (world.isClientSide()) {
            return;
        }
        ((ServerLevel)world).getDataStorage().set(WORLD_DATA_TYPE, (SavedData)this);
    }

    private void buildSpawn() {
        int rs4 = (this.spawnRadius - 2) * (this.spawnRadius - 2);
        int rs1 = (this.spawnRadius - 1) * (this.spawnRadius - 1);
        int hrs = (int)((float)this.spawnRadius * 0.65f);
        for (int x1 = -this.spawnRadius; x1 < this.spawnRadius; ++x1) {
            int XX = x1 * x1;
            for (int z1 = -this.spawnRadius; z1 < this.spawnRadius; ++z1) {
                int ZZ = z1 * z1 + XX;
                for (int y1 = -5; y1 < hrs; ++y1) {
                    int YY = y1 * y1 + ZZ;
                    if ((YY <= rs4 || YY >= this.spawnRadius2) && (y1 != -2 && y1 != -3 && y1 != -4 || YY >= rs1)) continue;
                    this.world.setBlockAndUpdate(this.cSpawn.atY(200).offset(x1, y1, z1), ((Block)RRBlocks.fshield.get()).defaultBlockState());
                }
            }
        }
        this.omegaData.objPos = new BlockPos(this.cSpawn.getX() + this.objDist, this.omegaData.objPos().getY(), this.cSpawn.getZ());
        this.sigmaData.objPos = new BlockPos(this.cSpawn.getX() - this.objDist, this.sigmaData.objPos().getY(), this.cSpawn.getZ());
        ChunkAccess chunk = this.world.getChunk(this.omegaData.objPos());
        this.omegaData.objPos = new BlockPos(this.omegaData.objPos().getX(), chunk.getHighestFilledSectionIndex() + 15, this.omegaData.objPos().getZ());
        while (this.omegaData.objPos().getY() > this.world.getMinY() && chunk.getBlockState(this.omegaData.objPos()).isAir()) {
            this.omegaData.objPos().below();
        }
        chunk = this.world.getChunk(this.sigmaData.objPos());
        this.sigmaData.objPos = new BlockPos(this.sigmaData.objPos().getX(), chunk.getHighestFilledSectionIndex() + 15, this.sigmaData.objPos().getZ());
        while (this.sigmaData.objPos().getY() > this.world.getMinY() && chunk.getBlockState(this.sigmaData.objPos()).isAir()) {
            this.sigmaData.objPos = this.sigmaData.objPos().below();
        }
        for (int xx = -this.objRadius; xx <= this.objRadius; ++xx) {
            int XX = xx * xx;
            for (int zz = -this.objRadius; zz <= this.objRadius; ++zz) {
                int ZZ = zz * zz + XX;
                if (ZZ > this.objRadius2) continue;
                if (Mth.abs((int)xx) == 15 && Mth.abs((int)zz) == 15) {
                    this.world.setBlockAndUpdate(this.omegaData.objPos().offset(xx, 0, zz), ((Block)RRBlocks.fshield.get()).defaultBlockState());
                    this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(xx, 0, zz), ((Block)RRBlocks.fshield.get()).defaultBlockState());
                } else {
                    this.world.setBlockAndUpdate(this.omegaData.objPos().offset(xx, 0, zz), ((Block)RRBlocks.reactive.get()).defaultBlockState());
                    this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(xx, 0, zz), ((Block)RRBlocks.reactive.get()).defaultBlockState());
                }
                for (int yy = 1; yy <= 7; ++yy) {
                    this.world.setBlockAndUpdate(this.omegaData.objPos().offset(xx, yy, zz), Blocks.AIR.defaultBlockState());
                    this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(xx, yy, zz), Blocks.AIR.defaultBlockState());
                }
            }
        }
        this.world.setBlockAndUpdate(this.omegaData.objPos().offset(21, 0, 21), ((Block)RRBlocks.conduit.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.omegaData.objPos().offset(21, 0, -21), ((Block)RRBlocks.conduit.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.omegaData.objPos().offset(-21, 0, 21), ((Block)RRBlocks.conduit.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.omegaData.objPos().offset(-21, 0, -21), ((Block)RRBlocks.conduit.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(21, 0, 21), ((Block)RRBlocks.conduit.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(21, 0, -21), ((Block)RRBlocks.conduit.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(-21, 0, 21), ((Block)RRBlocks.conduit.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(-21, 0, -21), ((Block)RRBlocks.conduit.get()).defaultBlockState());
        for (int i = 0; i < 4; ++i) {
            this.world.setBlockAndUpdate(this.omegaData.objPos().offset(21, 1 + i, 21), Blocks.AIR.defaultBlockState());
            this.world.setBlockAndUpdate(this.omegaData.objPos().offset(21, 1 + i, -21), Blocks.AIR.defaultBlockState());
            this.world.setBlockAndUpdate(this.omegaData.objPos().offset(-21, 1 + i, 21), Blocks.AIR.defaultBlockState());
            this.world.setBlockAndUpdate(this.omegaData.objPos().offset(-21, 1 + i, -21), Blocks.AIR.defaultBlockState());
            this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(21, 1 + i, 21), Blocks.AIR.defaultBlockState());
            this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(21, 1 + i, -21), Blocks.AIR.defaultBlockState());
            this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(-21, 1 + i, 21), Blocks.AIR.defaultBlockState());
            this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(-21, 1 + i, -21), Blocks.AIR.defaultBlockState());
        }
        this.world.setBlockAndUpdate(this.omegaData.objPos().above(), ((Block)RRBlocks.omegaobj.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.sigmaData.objPos().above(), ((Block)RRBlocks.sigmaobj.get()).defaultBlockState());
        if (RRConfig.SERVER.isRhodesRoundsBase()) {
            this.world.setBlockAndUpdate(this.omegaData.objPos().above(2), ((Block)RRBlocks.buildrhodes.get()).defaultBlockState());
            this.world.setBlockAndUpdate(this.sigmaData.objPos().above(2), ((Block)RRBlocks.buildrhodes.get()).defaultBlockState());
        }
    }

    private boolean isInSpawn(Player player) {
        return player.position().y() < 203.0 && player.position().y() > 198.0 && player.distanceToSqr((double)this.cSpawn.getX(), 200.0, (double)this.cSpawn.getZ()) < (double)this.spawnRadius2;
    }

    public void winSigma() {
        if (!this.roundstarted) {
            return;
        }
        this.winCountdown = 1400;
        ++this.sigmaData.winCount;
        this.lastWinnerTeam = RivalRebelsTeam.SIGMA;
        this.world.setBlockAndUpdate(this.omegaData.objPos(), ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.sigmaData.objPos(), ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState());
        for (int xpl = -this.objRadius; xpl < this.objRadius; ++xpl) {
            int xxpl = xpl * xpl;
            for (int zpl = -this.objRadius; zpl < this.objRadius; ++zpl) {
                int zzpl = zpl * zpl + xxpl;
                if (zzpl >= this.objRadius2) continue;
                for (int ypl = -1; ypl < 7; ++ypl) {
                    for (int i = 0; i < 16; ++i) {
                        this.world.setBlockAndUpdate(this.omegaData.objPos().offset(xpl, ypl, zpl), Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }
        this.sendUpdatePacket();
    }

    public void winOmega() {
        if (!this.roundstarted) {
            return;
        }
        this.winCountdown = 1400;
        ++this.omegaData.winCount;
        this.lastWinnerTeam = RivalRebelsTeam.OMEGA;
        this.world.setBlockAndUpdate(this.omegaData.objPos(), ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.sigmaData.objPos(), ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState());
        for (int xpl = -this.objRadius; xpl < this.objRadius; ++xpl) {
            int xxpl = xpl * xpl;
            for (int zpl = -this.objRadius; zpl < this.objRadius; ++zpl) {
                int zzpl = zpl * zpl + xxpl;
                if (zzpl >= this.objRadius2) continue;
                for (int ypl = -1; ypl < 7; ++ypl) {
                    for (int i = 0; i < 16; ++i) {
                        this.world.setBlockAndUpdate(this.sigmaData.objPos().offset(xpl, ypl, zpl), Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }
        this.sendUpdatePacket();
    }

    public void stopRounds() {
        if (!this.roundstarted) {
            return;
        }
        this.world.setBlockAndUpdate(this.omegaData.objPos(), ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState());
        this.world.setBlockAndUpdate(this.sigmaData.objPos(), ((Block)RRBlocks.plasmaexplosion.get()).defaultBlockState());
        this.winCountdown = 0;
        this.roundstarted = false;
        this.rrplayerlist.clearTeam();
        this.sendUpdatePacket();
    }

    public float takeOmegaHealth(float amnt) {
        if (amnt > (float)this.omegaData.health()) {
            int tmp = this.omegaData.health();
            this.omegaData.health = 0;
            this.winSigma();
            return tmp;
        }
        this.omegaData.health = (int)((float)this.omegaData.health - amnt);
        return amnt;
    }

    public float takeSigmaHealth(float amnt) {
        if (amnt > (float)this.sigmaData.health()) {
            int tmp = this.sigmaData.health();
            this.sigmaData.health = 0;
            this.winOmega();
            return tmp;
        }
        this.sigmaData.health = (int)((float)this.sigmaData.health - amnt);
        return amnt;
    }

    public int getOmegaWins() {
        return this.omegaData.winCount;
    }

    public int getSigmaWins() {
        return this.sigmaData.winCount;
    }

    public String getMotD() {
        return this.MotD;
    }

    public void setMotD(String motD) {
        this.MotD = motD;
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        if (this.world.isClientSide()) {
            return;
        }
        for (Player player : this.world.players()) {
            ((ServerPlayer)player).connection.send((CustomPacketPayload)this);
        }
    }

    public boolean isStarted() {
        return this.roundstarted;
    }

    public float addOmegaHealth(float power) {
        this.omegaData.health = (int)((float)this.omegaData.health + power);
        if (this.omegaData.health() > RRConfig.SERVER.getObjectiveHealth()) {
            int tmp = this.omegaData.health() - RRConfig.SERVER.getObjectiveHealth();
            this.omegaData.health = RRConfig.SERVER.getObjectiveHealth();
            return tmp;
        }
        return 0.0f;
    }

    public float addSigmaHealth(float power) {
        this.sigmaData.health = (int)((float)this.sigmaData.health + power);
        if (this.sigmaData.health() > RRConfig.SERVER.getObjectiveHealth()) {
            int tmp = this.sigmaData.health() - RRConfig.SERVER.getObjectiveHealth();
            this.sigmaData.health = RRConfig.SERVER.getObjectiveHealth();
            return tmp;
        }
        return 0.0f;
    }

    public static class PlayerInvisibility {
        public final Player player;
        public int durationLeft;

        public PlayerInvisibility(Player player, int durationLeft) {
            this.player = player;
            this.durationLeft = durationLeft;
        }
    }
}

