/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import io.github.kadir1243.rivalrebels.common.tileentity.Tickable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractObjectiveBlockEntity
extends BaseContainerBlockEntity
implements Tickable {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    private final BaseCommandBlock commandExecutor = new BaseCommandBlock(){

        public void setCommand(String command) {
            super.setCommand(command);
            AbstractObjectiveBlockEntity.this.setChanged();
        }

        public ServerLevel getLevel() {
            return (ServerLevel)AbstractObjectiveBlockEntity.this.level;
        }

        public void onUpdated() {
            BlockState lv = AbstractObjectiveBlockEntity.this.level.getBlockState(AbstractObjectiveBlockEntity.this.worldPosition);
            this.getLevel().sendBlockUpdated(AbstractObjectiveBlockEntity.this.worldPosition, lv, lv, 3);
        }

        public Vec3 getPosition() {
            return Vec3.atCenterOf((Vec3i)AbstractObjectiveBlockEntity.this.worldPosition);
        }

        public CommandSourceStack createCommandSourceStack() {
            return new CommandSourceStack((CommandSource)this, this.getPosition(), Vec2.ZERO, this.getLevel(), 2, this.getName().getString(), this.getName(), this.getLevel().getServer(), null);
        }

        public boolean isValid() {
            return !AbstractObjectiveBlockEntity.this.isRemoved();
        }
    };
    public double slide = 0.0;
    private float test = 3.0915928f;

    public AbstractObjectiveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public int getContainerSize() {
        return 16;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return null;
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
        this.commandExecutor.load(valueInput);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items);
        this.commandExecutor.save(valueOutput);
    }

    @Override
    public void tick() {
        this.slide = (Mth.cos((float)this.test) + 1.0f) / 32.0f * 10.0f;
        boolean i = this.level.hasNearbyAlivePlayer((double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f), 9.0);
        if (i) {
            if (this.slide < 0.621) {
                this.test += 0.05f;
            }
        } else if (this.slide > 0.004) {
            this.test -= 0.05f;
        }
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player, (float)64.0f);
    }
}

