/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.block.machine.BlockForceField;
import io.github.kadir1243.rivalrebels.common.block.machine.BlockForceFieldNode;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsPlayer;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityMachineBase;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class TileEntityForceFieldNode
extends TileEntityMachineBase {
    @Nullable
    public ResolvableProfile owner;
    public RivalRebelsTeam rrteam = RivalRebelsTeam.NONE;
    public int level = 0;

    public TileEntityForceFieldNode(BlockPos pos, BlockState state) {
        super((BlockEntityType)RRTileEntities.FORCE_FIELD_NODE.get(), pos, state);
        this.pInM = 345.0f;
        this.pInR = 345.0f;
    }

    @Override
    public void tick() {
        if (this.pInR > 0.0f) {
            this.pInR = this.powered(this.pInR, this.edist);
        } else {
            this.turnOff();
        }
        this.pInR -= this.decay;
    }

    public void turnOff() {
        if (this.level > 0) {
            Direction meta = (Direction)this.getBlockState().getValue(BlockForceFieldNode.FACING);
            --this.level;
            for (int y = 0; y < 7; ++y) {
                if (meta == Direction.NORTH) {
                    if (!this.getLevel().getBlockState(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + (y - 3), this.getBlockPos().getZ() - this.level - 1)).is(RRBlocks.forcefield)) continue;
                    this.getLevel().setBlockAndUpdate(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + (y - 3), this.getBlockPos().getZ() - this.level - 1), Blocks.AIR.defaultBlockState());
                    continue;
                }
                if (!this.getLevel().getBlockState(this.getBlockPos().offset(0, y, this.level).below(3).relative(meta)).is(RRBlocks.forcefield)) continue;
                this.getLevel().setBlockAndUpdate(this.getBlockPos().offset(0, y, this.level).below(3).relative(meta), Blocks.AIR.defaultBlockState());
            }
        }
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.rrteam = valueInput.read("rrteam", RivalRebelsTeam.CODEC).orElse(RivalRebelsTeam.NONE);
        this.owner = valueInput.read("profile", ResolvableProfile.CODEC).orElse(null);
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.store("rrteam", RivalRebelsTeam.CODEC, (Object)this.rrteam);
        valueOutput.storeNullable("profile", ResolvableProfile.CODEC, (Object)this.owner);
    }

    @Override
    public float powered(float power, float distance) {
        double dist;
        double cpz;
        double cpy;
        RivalRebelsPlayer player;
        boolean shouldContinue;
        List list;
        AABB aabb;
        float hits = this.getLevel().random.nextFloat();
        Direction meta = (Direction)this.getBlockState().getValue(BlockForceFieldNode.FACING);
        double randomness = 0.1;
        float thickness = 0.5f;
        float length = 35.0f;
        float height = 3.52f;
        double speed = 2.0;
        if (meta == Direction.NORTH) {
            aabb = new AABB((double)((float)this.getBlockPos().getX() + 0.5f - thickness), (double)((float)this.getBlockPos().getY() + 0.5f - height), (double)((float)this.getBlockPos().getZ() - length), (double)((float)this.getBlockPos().getX() + 0.5f + thickness), (double)((float)this.getBlockPos().getY() + 0.5f + height), (double)this.getBlockPos().getZ());
            list = this.getLevel().getEntities(null, aabb);
            for (Entity e : list) {
                shouldContinue = true;
                if (e instanceof Player) {
                    Player p = (Player)e;
                    player = RivalRebels.round.rrplayerlist.getForGameProfile(p.getGameProfile());
                    if (p.getGameProfile().equals(Optional.ofNullable(this.owner).map(ResolvableProfile::gameProfile).orElse(null)) || player != null && player.rrteam == this.rrteam) {
                        shouldContinue = false;
                        hits += 1.0f;
                        p.setPosRaw(p.getX() + (double)(p.getX() > (double)this.getBlockPos().getX() + 0.5 ? -2 : 2), p.getY(), p.getZ());
                    }
                }
                if (!shouldContinue || e == null) continue;
                double cpx = (double)((float)this.getBlockPos().getX() + 0.5f) - e.getX();
                cpy = e.getEyeY() - e.getY();
                cpz = e.getZ() - e.getZ();
                dist = Math.sqrt(cpx * cpx + cpy * cpy + cpz * cpz) / speed;
                cpx /= dist;
                cpy /= dist;
                cpz /= dist;
                e.setDeltaMovement(e.getDeltaMovement().reverse().subtract(cpx += this.getLevel().random.nextGaussian() * randomness, cpy += this.getLevel().random.nextGaussian() * randomness, cpz += this.getLevel().random.nextGaussian() * randomness));
                e.playSound((SoundEvent)RRSounds.GUI_UNKNOWN8.get(), 1.0f, 2.0f);
                if (e.getBoundingBox() == null) continue;
                hits = (float)((double)hits + e.getBoundingBox().getSize());
            }
            if ((float)this.level < length) {
                this.placeBlockCarefully(this.getLevel(), this.getBlockPos().getX(), this.getBlockPos().getY(), (int)((float)this.getBlockPos().getZ() - length - 1.0f), (Block)RRBlocks.reactive.get());
                for (int y = 0; y < 7; ++y) {
                    if (this.getLevel().getBlockState(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + (y - 3), this.getBlockPos().getZ() - this.level - 1)).is(RRBlocks.forcefield)) continue;
                    this.getLevel().setBlockAndUpdate(new BlockPos(this.getBlockPos().getX(), this.getBlockPos().getY() + (y - 3), this.getBlockPos().getZ() - this.level - 1), (BlockState)((Block)RRBlocks.forcefield.get()).defaultBlockState().setValue(BlockForceField.FACING, (Comparable)meta));
                    hits += 1.0f;
                }
                ++this.level;
            }
        }
        if (meta == Direction.SOUTH) {
            aabb = new AABB((double)((float)this.getBlockPos().getX() + 0.5f - thickness), (double)((float)this.getBlockPos().getY() + 0.5f - height), (double)((float)this.getBlockPos().getZ() + 1.0f), (double)((float)this.getBlockPos().getX() + 0.5f + thickness), (double)((float)this.getBlockPos().getY() + 0.5f + height), (double)((float)this.getBlockPos().getZ() + 1.0f + length));
            list = this.getLevel().getEntities(null, aabb);
            for (Entity e : list) {
                shouldContinue = true;
                if (e instanceof Player) {
                    Player p = (Player)e;
                    player = RivalRebels.round.rrplayerlist.getForGameProfile(p.getGameProfile());
                    if (p.getGameProfile().equals(Optional.ofNullable(this.owner).map(ResolvableProfile::gameProfile).orElse(null)) || player != null && player.rrteam == this.rrteam) {
                        shouldContinue = false;
                        hits += 1.0f;
                        p.setPosRaw(p.getX() + (double)(p.getX() > (double)this.getBlockPos().getX() + 0.5 ? -2 : 2), p.getY(), p.getZ());
                    }
                }
                if (!shouldContinue || e == null) continue;
                double cpx = (double)((float)this.getBlockPos().getX() + 0.5f) - e.getX();
                cpy = e.getEyeY() - e.getY();
                cpz = e.getZ() - e.getZ();
                dist = Math.sqrt(cpx * cpx + cpy * cpy + cpz * cpz) / speed;
                cpx /= dist;
                cpy /= dist;
                cpz /= dist;
                e.setDeltaMovement(e.getDeltaMovement().reverse().subtract(cpx += this.getLevel().random.nextGaussian() * randomness, cpy += this.getLevel().random.nextGaussian() * randomness, cpz += this.getLevel().random.nextGaussian() * randomness));
                e.playSound((SoundEvent)RRSounds.GUI_UNKNOWN8.get(), 1.0f, 2.0f);
                if (e.getBoundingBox() == null) continue;
                hits = (float)((double)hits + e.getBoundingBox().getSize());
            }
            if ((float)this.level < length) {
                this.placeBlockCarefully(this.getLevel(), this.getBlockPos().getX(), this.getBlockPos().getY(), (int)((float)this.getBlockPos().getZ() + length + 1.0f), (Block)RRBlocks.reactive.get());
                for (int y = 0; y < 7; ++y) {
                    if (this.getLevel().getBlockState(this.getBlockPos().offset(0, y, this.level).below(3).south()).is(RRBlocks.forcefield)) continue;
                    this.getLevel().setBlockAndUpdate(this.getBlockPos().offset(0, y, this.level).below(3).south(), (BlockState)((Block)RRBlocks.forcefield.get()).defaultBlockState().setValue(BlockForceField.FACING, (Comparable)meta));
                    hits += 1.0f;
                }
                ++this.level;
            }
        }
        if (meta == Direction.WEST) {
            aabb = new AABB((double)((float)this.getBlockPos().getX() - length), (double)((float)this.getBlockPos().getY() + 0.5f - height), (double)((float)this.getBlockPos().getZ() + 0.5f - thickness), (double)this.getBlockPos().getX(), (double)((float)this.getBlockPos().getY() + 0.5f + height), (double)((float)this.getBlockPos().getZ() + 0.5f + thickness));
            list = this.getLevel().getEntities(null, aabb);
            for (Entity e : list) {
                shouldContinue = true;
                if (e instanceof Player) {
                    Player p = (Player)e;
                    player = RivalRebels.round.rrplayerlist.getForGameProfile(p.getGameProfile());
                    if (p.getGameProfile().equals(Optional.ofNullable(this.owner).map(ResolvableProfile::gameProfile).orElse(null)) || player != null && player.rrteam == this.rrteam) {
                        shouldContinue = false;
                        hits += 1.0f;
                        p.setPosRaw(p.getX(), p.getY(), p.getZ() + (double)(p.getZ() > (double)this.getBlockPos().getZ() + 0.5 ? -2 : 2));
                    }
                }
                if (!shouldContinue || e == null) continue;
                double cpx = e.getX() - e.getX();
                cpy = e.getEyeY() - e.getY();
                cpz = (double)((float)this.getBlockPos().getZ() + 0.5f) - e.getZ();
                dist = Math.sqrt(cpx * cpx + cpy * cpy + cpz * cpz) / speed;
                cpx /= dist;
                cpy /= dist;
                cpz /= dist;
                e.setDeltaMovement(e.getDeltaMovement().reverse().subtract(cpx += this.getLevel().random.nextGaussian() * randomness, cpy += this.getLevel().random.nextGaussian() * randomness, cpz += this.getLevel().random.nextGaussian() * randomness));
                e.playSound((SoundEvent)RRSounds.GUI_UNKNOWN8.get(), 1.0f, 2.0f);
                if (e.getBoundingBox() == null) continue;
                hits = (float)((double)hits + e.getBoundingBox().getSize());
            }
            if ((float)this.level < length) {
                this.placeBlockCarefully(this.getLevel(), (int)((float)this.getBlockPos().getX() - length - 1.0f), this.getBlockPos().getY(), this.getBlockPos().getZ(), (Block)RRBlocks.reactive.get());
                for (int y = 0; y < 7; ++y) {
                    if (this.getLevel().getBlockState(this.getBlockPos().offset(-this.level, y, 0).below(3).west()).is(RRBlocks.forcefield)) continue;
                    this.getLevel().setBlockAndUpdate(this.getBlockPos().offset(-this.level, y, 0).below(3).west(), (BlockState)((Block)RRBlocks.forcefield.get()).defaultBlockState().setValue(BlockForceField.FACING, (Comparable)meta));
                    hits += 1.0f;
                }
                ++this.level;
            }
        }
        if (meta == Direction.EAST) {
            aabb = new AABB((double)((float)this.getBlockPos().getX() + 1.0f), (double)((float)this.getBlockPos().getY() + 0.5f - height), (double)((float)this.getBlockPos().getZ() + 0.5f - thickness), (double)((float)this.getBlockPos().getX() + 1.0f + length), (double)((float)this.getBlockPos().getY() + 0.5f + height), (double)((float)this.getBlockPos().getZ() + 0.5f + thickness));
            list = this.getLevel().getEntities(null, aabb);
            for (Entity e : list) {
                shouldContinue = true;
                if (e instanceof Player) {
                    Player p = (Player)e;
                    player = RivalRebels.round.rrplayerlist.getForGameProfile(p.getGameProfile());
                    if (p.getGameProfile().equals(Optional.ofNullable(this.owner).map(ResolvableProfile::gameProfile).orElse(null)) || player != null && player.rrteam == this.rrteam) {
                        shouldContinue = false;
                        hits += 1.0f;
                        p.setPosRaw(p.getX(), p.getY(), p.getZ() + (double)(p.getZ() > (double)this.getBlockPos().getZ() + 0.5 ? -2 : 2));
                    }
                }
                if (!shouldContinue || e == null) continue;
                double cpx = e.getX() - e.getX();
                cpy = e.getEyeY() - e.getY();
                cpz = (double)((float)this.getBlockPos().getZ() + 0.5f) - e.getZ();
                dist = Math.sqrt(cpx * cpx + cpy * cpy + cpz * cpz) / speed;
                cpx /= dist;
                cpy /= dist;
                cpz /= dist;
                e.setDeltaMovement(e.getDeltaMovement().reverse().subtract(cpx += this.getLevel().random.nextGaussian() * randomness, cpy += this.getLevel().random.nextGaussian() * randomness, cpz += this.getLevel().random.nextGaussian() * randomness));
                e.playSound((SoundEvent)RRSounds.GUI_UNKNOWN8.get(), 1.0f, 2.0f);
                if (e.getBoundingBox() == null) continue;
                hits = (float)((double)hits + e.getBoundingBox().getSize());
            }
            if ((float)this.level < length) {
                this.placeBlockCarefully(this.getLevel(), (int)((float)this.getBlockPos().getX() + length + 1.0f), this.getBlockPos().getY(), this.getBlockPos().getZ(), (Block)RRBlocks.reactive.get());
                for (int y = 0; y < 7; ++y) {
                    if (this.getLevel().getBlockState(this.getBlockPos().offset(this.level, y, 0).below(3).east()).is((Block)RRBlocks.forcefield.get())) continue;
                    this.getLevel().setBlockAndUpdate(this.getBlockPos().offset(this.level, y, 0).below(3).east(), (BlockState)((Block)RRBlocks.forcefield.get()).defaultBlockState().setValue(BlockForceField.FACING, (Comparable)meta));
                    hits += 1.0f;
                }
                ++this.level;
            }
        }
        return power - hits * 16.0f;
    }

    public void placeBlockCarefully(Level world, int x, int y, int z, Block block) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = world.getBlockState(pos);
        if (!(state.is(RRBlocks.reactive) || state.is(RRBlocks.fshield) || state.is(RRBlocks.omegaobj) || state.is(RRBlocks.sigmaobj))) {
            world.setBlockAndUpdate(pos, block.defaultBlockState());
        }
    }
}

