/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.container.ContainerLaptop;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.ChipData;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.item.weapon.ItemBinoculars;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.Tickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class TileEntityLaptop
extends BaseContainerBlockEntity
implements Tickable {
    public RivalRebelsTeam rrteam = RivalRebelsTeam.NONE;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)14, (Object)ItemStack.EMPTY);
    public float slide = 0.0f;
    private float test = (float)Math.PI;
    public int b2spirit = 0;
    public int b2carpet = 0;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> {
                    if (TileEntityLaptop.this.isReady()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 1 -> {
                    if (TileEntityLaptop.this.hasChips()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> TileEntityLaptop.this.b2spirit;
                case 3 -> TileEntityLaptop.this.b2carpet;
                case 4 -> TileEntityLaptop.this.getBlockPos().getX();
                case 5 -> TileEntityLaptop.this.getBlockPos().getY();
                case 6 -> TileEntityLaptop.this.getBlockPos().getZ();
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 2: {
                    TileEntityLaptop.this.b2spirit = value;
                    break;
                }
                case 3: {
                    TileEntityLaptop.this.b2carpet = value;
                    break;
                }
            }
        }

        public int getCount() {
            return 7;
        }
    };

    public TileEntityLaptop(BlockPos pos, BlockState state) {
        super((BlockEntityType)RRTileEntities.LAPTOP.get(), pos, state);
    }

    public int getContainerSize() {
        return 14;
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.items);
        this.b2spirit = valueInput.getIntOr("b2spirit", 0);
        this.b2carpet = valueInput.getIntOr("b2carpet", 0);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.items);
        valueOutput.putInt("b2spirit", this.b2spirit);
        valueOutput.putInt("b2carpet", this.b2carpet);
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player, (float)64.0f);
    }

    public void onGoButtonPressed() {
        if (this.isReady()) {
            for (int j = 0; j < 3; ++j) {
                if (this.getItem(j + 6).isEmpty() || this.getItem(j + 11).isEmpty()) continue;
                if (this.getItem(j + 6).is(RRItems.NUCLEAR_ROD) && this.getItem(j + 11).is(RRItems.hydrod)) {
                    ++this.b2spirit;
                    this.setItem(j + 6, ItemStack.EMPTY);
                    this.setItem(j + 11, ItemStack.EMPTY);
                    continue;
                }
                if (!this.getItem(j + 6).is(RRBlocks.timedbomb.asItem()) || !this.getItem(j + 11).is(RRBlocks.timedbomb.asItem())) continue;
                ++this.b2carpet;
                this.setItem(j + 6, ItemStack.EMPTY);
                this.setItem(j + 11, ItemStack.EMPTY);
            }
            this.setItem(4, ItemStack.EMPTY);
            this.setItem(5, ItemStack.EMPTY);
            this.setItem(9, ItemStack.EMPTY);
            this.setItem(10, ItemStack.EMPTY);
        }
        if (RRConfig.SERVER.isFreeb83nukes()) {
            this.b2spirit += 10;
            this.b2carpet += 10;
        }
    }

    public boolean hasChips() {
        boolean r = true;
        this.rrteam = RivalRebelsTeam.NONE;
        for (int j = 0; j < 4; ++j) {
            ItemStack stack = this.getItem(j);
            if (stack.isEmpty()) {
                r = false;
                continue;
            }
            if (!stack.has(RRComponents.CHIP_DATA)) continue;
            ChipData chipData = (ChipData)stack.get(RRComponents.CHIP_DATA);
            if (this.rrteam == RivalRebelsTeam.NONE) {
                this.rrteam = chipData.team();
                continue;
            }
            if (this.rrteam == chipData.team()) continue;
            r = false;
        }
        return r;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Override
    public void tick() {
        this.slide = (Mth.cos((float)this.test) + 1.0f) * 45.0f;
        ItemBinoculars.add(this);
        boolean i = this.level.hasNearbyAlivePlayer((double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f), 9.0);
        if (i) {
            if ((double)this.slide < 89.995) {
                this.test += 0.05f;
            }
        } else if ((double)this.slide > 0.004) {
            this.test -= 0.05f;
        }
        if (this.b2spirit > 0 && !this.hasChips()) {
            --this.b2spirit;
        }
    }

    public void setRemoved() {
        super.setRemoved();
        ItemBinoculars.remove(this);
    }

    protected Component getDefaultName() {
        return Component.literal((String)"Laptop");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public boolean isReady() {
        return this.hasChips() && !this.getItem(4).isEmpty() && !this.getItem(5).isEmpty() && !this.getItem(9).isEmpty() && !this.getItem(10).isEmpty();
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ContainerLaptop(containerId, inventory, (Container)this, this.propertyDelegate);
    }
}

