/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import com.mojang.authlib.GameProfile;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockNuclearBomb;
import io.github.kadir1243.rivalrebels.common.container.ContainerNuclearBomb;
import io.github.kadir1243.rivalrebels.common.entity.EntityNuke;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.ChipData;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.Tickable;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class TileEntityNuclearBomb
extends BaseContainerBlockEntity
implements Tickable {
    public GameProfile player = null;
    public RivalRebelsTeam rrteam = null;
    private NonNullList<ItemStack> chestContents = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
    public int Countdown = RRConfig.SERVER.getNuclearBombCountdown() * 20;
    public int AmountOfCharges = 0;
    public boolean hasTrollface = false;
    public boolean hasExplosive = false;
    public boolean hasFuse = false;
    public boolean hasChip = false;
    private final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> TileEntityNuclearBomb.this.Countdown;
                case 1 -> TileEntityNuclearBomb.this.AmountOfCharges;
                case 2 -> {
                    if (TileEntityNuclearBomb.this.hasTrollface) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> {
                    if (TileEntityNuclearBomb.this.hasExplosive) {
                        yield 1;
                    }
                    yield 0;
                }
                case 4 -> {
                    if (TileEntityNuclearBomb.this.hasFuse) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityNuclearBomb.this.Countdown = value;
                    break;
                }
                case 1: {
                    TileEntityNuclearBomb.this.AmountOfCharges = value;
                    break;
                }
                case 2: {
                    TileEntityNuclearBomb.this.hasTrollface = value == 1;
                    break;
                }
                case 3: {
                    TileEntityNuclearBomb.this.hasExplosive = value == 1;
                    break;
                }
                case 4: {
                    TileEntityNuclearBomb.this.hasFuse = value == 1;
                    break;
                }
            }
        }

        public int getCount() {
            return 5;
        }
    };

    public TileEntityNuclearBomb(BlockPos pos, BlockState state) {
        super((BlockEntityType)RRTileEntities.NUCLEAR_BOMB.get(), pos, state);
    }

    public int getContainerSize() {
        return 13;
    }

    public List<ItemStack> getRods() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i <= 4; ++i) {
            list.add(this.getItem(i + 1));
            list.add(this.getItem(i + 6));
        }
        return list;
    }

    public void setChanged() {
        super.setChanged();
        this.hasTrollface = false;
        this.AmountOfCharges = 0;
        for (ItemStack rod : this.getRods()) {
            this.hasTrollface |= rod.is(RRItems.trollmask);
            if (!rod.is(RRItems.NUCLEAR_ROD)) continue;
            ++this.AmountOfCharges;
        }
        this.hasFuse = this.getItem(0).is(RRItems.fuse);
        this.hasChip = this.getItem(12).is(RRItems.chip);
        if (this.hasChip) {
            ChipData chipData = (ChipData)this.getItem(12).get(RRComponents.CHIP_DATA);
            this.rrteam = chipData.team();
            this.player = chipData.gameProfile();
        }
        this.hasExplosive = this.getItem(11).is(RRBlocks.timedbomb.asItem());
    }

    protected void loadAdditional(ValueInput p_422403_) {
        super.loadAdditional(p_422403_);
        ContainerHelper.loadAllItems((ValueInput)p_422403_, this.chestContents);
    }

    protected void saveAdditional(ValueOutput p_422177_) {
        super.saveAdditional(p_422177_);
        ContainerHelper.saveAllItems((ValueOutput)p_422177_, this.chestContents);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player, (float)64.0f);
    }

    @Override
    public void tick() {
        boolean sp;
        boolean bl = sp = this.level.isClientSide() || !this.level.isClientSide() && (this.level.getServer().isSingleplayer() || this.level.getServer().getPlayerCount() == 1);
        if (this.hasFuse && this.hasExplosive && this.hasChip) {
            double dist = 1.0E7;
            if (!sp || RRConfig.SERVER.isStopSelfnukeinSP()) {
                if (this.rrteam == RivalRebelsTeam.OMEGA) {
                    dist = this.getBlockPos().distToLowCornerSqr((double)RivalRebels.round.omegaData.objPos().getX(), (double)this.getBlockPos().getY(), (double)RivalRebels.round.omegaData.objPos().getZ());
                } else if (this.rrteam == RivalRebelsTeam.SIGMA) {
                    dist = this.getBlockPos().distToLowCornerSqr((double)RivalRebels.round.sigmaData.objPos().getX(), (double)this.getBlockPos().getY(), (double)RivalRebels.round.sigmaData.objPos().getZ());
                }
            }
            if (dist > (double)((RRConfig.SERVER.getNuclearBombStrength() + this.AmountOfCharges * this.AmountOfCharges + 29) * (RRConfig.SERVER.getNuclearBombStrength() + this.AmountOfCharges * this.AmountOfCharges + 29))) {
                if (this.Countdown > 0) {
                    --this.Countdown;
                }
            } else if (!this.level.isClientSide()) {
                this.setItem(0, ItemStack.EMPTY);
                for (Player player : this.level.players()) {
                    player.displayClientMessage((Component)Translations.warning().append(" ").append((Component)this.level.getPlayerByUUID(player.getUUID()).getName().copy().withStyle(ChatFormatting.RED)), false);
                    player.displayClientMessage((Component)Component.translatable((String)"rivalrebels.nuke_bomb_defuse", (Object[])new Object[]{this.rrteam.getBlockName()}), false);
                }
            }
        } else {
            this.Countdown = RRConfig.SERVER.getNuclearBombCountdown() * 20;
        }
        if (this.Countdown == 200 && !this.level.isClientSide() && RRConfig.SERVER.getNuclearBombCountdown() > 10) {
            Translations.sendWarningBombWillExplodeMessageToPlayers(this.getLevel());
        }
        if (this.Countdown == 0 && this.AmountOfCharges != 0 && !this.level.isClientSide()) {
            this.level.setSkyFlashTime(2);
            Direction facing = (Direction)this.getBlockState().getValue(BlockNuclearBomb.FACING);
            float pitch = facing.getAxis().isVertical() ? facing.toYRot() : 0.0f;
            float yaw = facing.getAxis().isHorizontal() ? facing.toYRot() : 0.0f;
            this.level.addFreshEntity((Entity)new EntityNuke(this.level, (float)this.getBlockPos().getX() + 0.5f, (float)this.getBlockPos().getY() + 0.5f, (float)this.getBlockPos().getZ() + 0.5f, yaw, pitch, this.AmountOfCharges, this.hasTrollface));
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
        }
        if (this.Countdown == 0 && this.AmountOfCharges == 0) {
            this.level.explode(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), 4.0f, Level.ExplosionInteraction.BLOCK);
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
        }
    }

    protected Component getDefaultName() {
        return Component.literal((String)"Nuclear Bomb");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ContainerNuclearBomb(containerId, inventory, (Container)this, this.containerData);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.chestContents;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.chestContents = items;
    }
}

