/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.block.machine.BlockReciever;
import io.github.kadir1243.rivalrebels.common.container.ContainerReciever;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityRhodes;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.ChipData;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.item.weapon.ItemRoda;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsPlayer;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.TileEntityMachineBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.model.data.ModelData;
import net.neoforged.neoforge.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TileEntityReciever
extends TileEntityMachineBase
implements Container,
MenuConstructor {
    public float yaw;
    public float pitch;
    public Entity target;
    public float xO = 0.0f;
    public float zO = 0.0f;
    double ll = -50.0;
    double ul = 90.0;
    private final float scale = 1.5f;
    public final NonNullList<ItemStack> chestContents = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    private int ticksSinceLastTarget = 0;
    public int yawLimit = 180;
    public boolean kTeam = true;
    public boolean kPlayers = false;
    public boolean kMobs = true;
    public boolean hasWeapon = false;
    private RivalRebelsTeam team = RivalRebelsTeam.NONE;
    private int ammoCounter;
    private Vector3f prevTpos = new Vector3f();
    private Entity le = null;
    public int wepSelected;
    public static int staticEntityIndex = 1;
    public int entityIndex;
    @Nullable
    public ResolvableProfile owner;
    private int ticksincepacket;
    int ticksSinceLastShot = 0;
    public static final ModelProperty<Float> YAW = new ModelProperty(aFloat -> aFloat != null && !aFloat.isNaN());
    public static final ModelProperty<Float> PITCH = new ModelProperty(aFloat -> aFloat != null && !aFloat.isNaN());
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> TileEntityReciever.this.yawLimit;
                case 1 -> {
                    if (TileEntityReciever.this.kTeam) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> {
                    if (TileEntityReciever.this.kPlayers) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> {
                    if (TileEntityReciever.this.kMobs) {
                        yield 1;
                    }
                    yield 0;
                }
                case 4 -> {
                    if (TileEntityReciever.this.hasWeapon) {
                        yield 1;
                    }
                    yield 0;
                }
                case 5 -> {
                    if (TileEntityReciever.this.hasWepReqs()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 6 -> Float.floatToIntBits(TileEntityReciever.this.pInR);
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 1: {
                    TileEntityReciever.this.kTeam = value == 1;
                    break;
                }
                case 2: {
                    TileEntityReciever.this.kPlayers = value == 1;
                    break;
                }
                case 3: {
                    TileEntityReciever.this.kMobs = value == 1;
                    break;
                }
                case 4: {
                    TileEntityReciever.this.hasWeapon = value == 1;
                    break;
                }
                case 5: {
                    TileEntityReciever.this.setWep(value);
                    break;
                }
            }
        }

        public int getCount() {
            return 7;
        }
    };

    public TileEntityReciever(BlockPos pos, BlockState state) {
        super((BlockEntityType)RRTileEntities.RECIEVER.get(), pos, state);
        this.entityIndex = staticEntityIndex;
        this.pInM = 400.0f;
        if (RRConfig.SERVER.isFreeDragonAmmo()) {
            this.hasWeapon = true;
            this.kPlayers = true;
            this.setItem(3, RRItems.battery.toStack(64));
            this.setItem(4, RRItems.battery.toStack(64));
            this.setItem(5, RRItems.battery.toStack(64));
            this.setItem(0, RRItems.fuel.toStack(64));
            this.setItem(1, RRItems.fuel.toStack(64));
            this.setItem(2, RRItems.fuel.toStack(64));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.xO == this.zO) {
            this.updateDirection();
        }
        this.powered(0.0f, 0.0f);
        this.convertBatteryToEnergy();
        if (!this.hasWeapon && this.wepSelected != 0 && this.hasWepReqs()) {
            this.setWep(this.wepSelected);
        }
    }

    private boolean hasBattery() {
        return !this.getItem(3).isEmpty() || !this.getItem(4).isEmpty() || !this.getItem(5).isEmpty() || RRConfig.SERVER.isInfiniteAmmo();
    }

    private void convertBatteryToEnergy() {
        while (this.pInR < this.pInM / 2.0f && this.hasBattery()) {
            this.pInR += 800.0f;
            this.consumeBattery();
        }
    }

    private void consumeBattery() {
        if (!this.getItem(3).isEmpty()) {
            this.removeItem(3, 1);
        } else if (!this.getItem(4).isEmpty()) {
            this.removeItem(4, 1);
        } else if (!this.getItem(5).isEmpty()) {
            this.removeItem(5, 1);
        }
    }

    public boolean hasWepReqs() {
        return !this.getItem(6).isEmpty() && !this.getItem(7).isEmpty() && !this.getItem(8).isEmpty();
    }

    public void setWep(int wep) {
        if (wep != 0) {
            if (!this.getItem(6).isEmpty() && this.getItem(6).has(RRComponents.CHIP_DATA)) {
                ChipData chipData = (ChipData)this.getItem(6).get(RRComponents.CHIP_DATA);
                this.team = chipData.team();
                this.owner = new ResolvableProfile(chipData.gameProfile());
            }
            this.setItem(6, ItemStack.EMPTY);
            this.setItem(7, ItemStack.EMPTY);
            this.setItem(8, ItemStack.EMPTY);
            this.hasWeapon = true;
            this.wepSelected = 0;
        }
    }

    @Override
    public float powered(float power, float distance) {
        if (this.hasWeapon) {
            ++this.ticksSinceLastTarget;
            if (this.ticksSinceLastTarget == 3) {
                this.target = this.getTarget();
                this.ticksSinceLastTarget = 0;
            }
            ++this.ticksSinceLastShot;
            if (this.ticksSinceLastShot > ItemRoda.rates[this.entityIndex] && this.target != null) {
                this.ticksSinceLastShot = 0;
                this.lookAt(this.target);
                if (this.hasAmmo()) {
                    if (this.level.random.nextInt(3) == 0) {
                        this.getLevel().playLocalSound(this.getBlockPos(), (SoundEvent)RRSounds.FLAME_THROWER_EXTINGUISH.get(), SoundSource.BLOCKS, 0.1f, 1.0f, false);
                    }
                    float yaw = 180.0f - this.yaw;
                    float pitch = -this.pitch;
                    double motionX = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
                    double motionZ = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
                    double motionY = -Mth.sin((float)(pitch * ((float)Math.PI / 180)));
                    ItemRoda.spawn(this.entityIndex, this.level, (double)((float)this.getBlockPos().getX() + this.xO) + 0.5, (double)this.getBlockPos().getY() + 0.75, (double)((float)this.getBlockPos().getZ() + this.zO) + 0.5, motionX, motionY, motionZ, 1.0, 0.0);
                    this.useAmmo();
                }
                return power - 4.0f;
            }
            ++this.ticksincepacket;
            if (this.ticksincepacket > 6 && !this.level.isClientSide()) {
                this.ticksincepacket = 0;
            }
        }
        return power - 1.0f;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ModelData getModelData() {
        return ModelData.builder().with(YAW, (Object)Float.valueOf(this.yaw)).with(PITCH, (Object)Float.valueOf(this.pitch)).build();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    private boolean hasAmmo() {
        return !this.getItem(0).isEmpty() || !this.getItem(1).isEmpty() || !this.getItem(2).isEmpty() || RRConfig.SERVER.isInfiniteAmmo();
    }

    private boolean useAmmo() {
        ++this.ammoCounter;
        if (this.ammoCounter == 9) {
            this.ammoCounter = 0;
            if (!this.getItem(0).isEmpty()) {
                this.removeItem(0, 1);
            } else if (!this.getItem(1).isEmpty()) {
                this.removeItem(1, 1);
            } else if (!this.getItem(2).isEmpty()) {
                this.removeItem(2, 1);
            } else {
                return false;
            }
            return true;
        }
        return true;
    }

    private Entity getTarget() {
        double ldist = 1600.0;
        Entity result = null;
        AABB box = AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)this.getBlockPos().offset(40, 40, 40), (Vec3i)this.getBlockPos().offset(-40, -40, -40)));
        for (Entity e : this.level.getEntities((Entity)null, box, this::canTarget)) {
            double dist = e.distanceToSqr((double)this.getBlockPos().getX() + 0.5 + (double)this.xO, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5 + (double)this.zO);
            if (!(dist < ldist)) continue;
            ldist = dist;
            result = e;
        }
        return result;
    }

    private boolean canTarget(Entity e) {
        return (e instanceof LivingEntity && ((LivingEntity)e).getHealth() > 0.0f || e instanceof EntityRhodes) && (double)this.getPitchTo(e, 0.0f) > this.ll && (double)this.getPitchTo(e, 0.0f) < this.ul && this.isValidTarget(e) && this.canSee(e);
    }

    private boolean isValidTarget(Entity e) {
        if (e == null || e.isInvulnerable()) {
            return false;
        }
        if (e instanceof Player) {
            Player p = (Player)e;
            if (this.kPlayers) {
                return true;
            }
            if (!this.kTeam) {
                return false;
            }
            RivalRebelsPlayer rrp = RivalRebels.round.rrplayerlist.getForGameProfile(((Player)e).getGameProfile());
            if (rrp == null) {
                return this.kTeam;
            }
            if (rrp.rrteam == RivalRebelsTeam.NONE) {
                return !p.getGameProfile().equals(this.owner != null ? this.owner.gameProfile() : null);
            }
            if (rrp.rrteam != this.team) {
                return this.kTeam;
            }
            return false;
        }
        return this.kMobs && (e instanceof EntityRhodes || e instanceof Mob && !(e instanceof Animal) && !(e instanceof Bat) && !(e instanceof Villager) && !(e instanceof Squid) || e instanceof Ghast);
    }

    private boolean canSee(Entity e) {
        Vec3 end;
        int yaw = (int)(this.getYawTo(e, 0.0f) - (float)this.getBaseRotation() + 360.0f) % 360;
        if (Mth.abs((int)yaw) > this.yawLimit / 2 && Mth.abs((int)yaw) < 360 - this.yawLimit / 2) {
            return false;
        }
        Vec3 start = e.getEyePosition();
        BlockHitResult mop = this.level.clip(new ClipContext(start, end = new Vec3((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()).add(0.5 + (double)this.xO, 0.5, 0.5 + (double)this.zO), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, CollisionContext.empty()));
        return mop == null || mop.getBlockPos().equals((Object)this.getBlockPos());
    }

    private void updateDirection() {
        Direction direction = (Direction)this.getBlockState().getValue(BlockReciever.FACING);
        this.xO = 0.0f;
        this.zO = 0.0f;
        if (direction == Direction.NORTH) {
            this.zO = -0.76f;
        } else if (direction == Direction.WEST) {
            this.xO = -0.76f;
        } else if (direction == Direction.SOUTH) {
            this.zO = 0.76f;
        } else if (direction == Direction.EAST) {
            this.xO = 0.76f;
        }
    }

    public int lookAt(Entity t) {
        float dist = Mth.sqrt((float)((float)t.distanceToSqr((double)this.getBlockPos().getX() + 0.5 + (double)this.xO, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5 + (double)this.zO)));
        float ya = this.getYawTo(t, this.le == t ? dist : 0.0f);
        float pi = this.getPitchTo(t, this.le == t ? dist : 0.0f);
        if ((double)pi > this.ll && (double)pi < this.ul) {
            this.pitch = (this.pitch + this.pitch + this.pitch + pi) / 4.0f;
            if (this.yaw - ya < -180.0f) {
                this.yaw += 360.0f;
            } else if (this.yaw - ya > 180.0f) {
                this.yaw -= 360.0f;
            }
            this.yaw = (this.yaw + this.yaw + this.yaw + ya) / 4.0f;
            this.prevTpos = t.position().toVector3f();
            this.le = t;
            this.requestModelDataUpdate();
            return 1;
        }
        return 0;
    }

    public float getYawTo(Entity t, float off) {
        double x = (double)((float)this.getBlockPos().getX() + 0.5f + this.xO) - t.getX() - (t.getX() - (double)this.prevTpos.x()) * (double)off;
        double z = (double)((float)this.getBlockPos().getZ() + 0.5f + this.zO) - t.getZ() - (t.getZ() - (double)this.prevTpos.z()) * (double)off;
        double ya = Math.atan2(x, z);
        return (float)(ya * 0.01745329238474369);
    }

    public float getPitchTo(Entity t, float off) {
        double x = (double)((float)this.getBlockPos().getX() + 0.5f + this.xO) - t.getX() - (t.getX() - (double)this.prevTpos.x()) * (double)off;
        double y = (double)((float)this.getBlockPos().getY() + 0.75f) - t.getEyeY() - (t.getY() - (double)this.prevTpos.y()) * (double)off;
        double z = (double)((float)this.getBlockPos().getZ() + 0.5f + this.zO) - t.getZ() - (t.getZ() - (double)this.prevTpos.z()) * (double)off;
        double d = Math.sqrt(x * x + z * z);
        double pi = Math.atan2(d, -y);
        return (float)(90.0 - pi / 3.1415927410125732 * 180.0);
    }

    public int getBaseRotation() {
        return (int)((Direction)this.getBlockState().getValue(BlockReciever.FACING)).toYRot();
    }

    public int getContainerSize() {
        return 9;
    }

    public ItemStack getItem(int slot) {
        if (slot >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.chestContents.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        if (!this.getItem(slot).isEmpty()) {
            ItemStack var3;
            if (this.getItem(slot).getCount() <= amount) {
                var3 = this.getItem(slot);
                this.setItem(slot, ItemStack.EMPTY);
            } else {
                var3 = this.getItem(slot).split(amount);
                if (this.getItem(slot).isEmpty()) {
                    this.setItem(slot, ItemStack.EMPTY);
                }
            }
            return var3;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (slot >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        if (!this.getItem(slot).isEmpty()) {
            ItemStack var2 = this.getItem(slot);
            this.setItem(slot, ItemStack.EMPTY);
            return var2;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot >= this.getContainerSize()) {
            return;
        }
        this.chestContents.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player, (float)64.0f);
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.chestContents);
        this.yawLimit = valueInput.getInt("yawLimit").orElse(0);
        this.kPlayers = valueInput.getBooleanOr("kPlayers", false);
        this.kTeam = valueInput.getBooleanOr("kTeam", false);
        this.kMobs = valueInput.getBooleanOr("kMobs", false);
        this.hasWeapon = valueInput.getBooleanOr("hasWeapon", false);
        this.owner = valueInput.read("owner", ResolvableProfile.CODEC).orElse(null);
        this.team = valueInput.read("team", RivalRebelsTeam.CODEC).orElse(RivalRebelsTeam.NONE);
        this.entityIndex = valueInput.getInt("entityIndex").orElse(0);
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.chestContents);
        valueOutput.putInt("yawLimit", this.yawLimit);
        valueOutput.putBoolean("kPlayers", this.kPlayers);
        valueOutput.putBoolean("kTeam", this.kTeam);
        valueOutput.putBoolean("kMobs", this.kMobs);
        valueOutput.putBoolean("hasWeapon", this.hasWeapon);
        valueOutput.storeNullable("owner", ResolvableProfile.CODEC, (Object)this.owner);
        valueOutput.putInt("entityIndex", this.entityIndex);
        valueOutput.store("team", RivalRebelsTeam.CODEC, (Object)this.team);
    }

    public void clearContent() {
        this.chestContents.clear();
    }

    public boolean isEmpty() {
        return this.chestContents.stream().allMatch(ItemStack::isEmpty);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return new ContainerReciever(syncId, inv, this, this.propertyDelegate);
    }
}

