/*
 * Decompiled with CFR 0.152.
 */
package io.github.kadir1243.rivalrebels.common.tileentity;

import com.mojang.authlib.GameProfile;
import io.github.kadir1243.rivalrebels.RRConfig;
import io.github.kadir1243.rivalrebels.RivalRebels;
import io.github.kadir1243.rivalrebels.common.block.RRBlocks;
import io.github.kadir1243.rivalrebels.common.block.trap.BlockTheoreticalTsarBomba;
import io.github.kadir1243.rivalrebels.common.container.ContainerTheoreticalTsar;
import io.github.kadir1243.rivalrebels.common.core.RRSounds;
import io.github.kadir1243.rivalrebels.common.entity.EntityTheoreticalTsar;
import io.github.kadir1243.rivalrebels.common.item.RRItems;
import io.github.kadir1243.rivalrebels.common.item.components.ChipData;
import io.github.kadir1243.rivalrebels.common.item.components.RRComponents;
import io.github.kadir1243.rivalrebels.common.round.RivalRebelsTeam;
import io.github.kadir1243.rivalrebels.common.tileentity.RRTileEntities;
import io.github.kadir1243.rivalrebels.common.tileentity.Tickable;
import io.github.kadir1243.rivalrebels.common.util.Translations;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class TileEntityTheoreticalTsarBomba
extends BaseContainerBlockEntity
implements Tickable {
    public GameProfile player = null;
    public RivalRebelsTeam rrteam = null;
    private NonNullList<ItemStack> chestContents = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
    public int countdown = RRConfig.SERVER.getNuclearBombCountdown() * 20;
    public int nuclear = 0;
    public boolean hasAntennae = false;
    public boolean hasExplosive = false;
    public boolean hasFuse = false;
    public boolean hasChip = false;
    public boolean hasTrollface = false;
    public float megaton = 0.0f;
    private final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> TileEntityTheoreticalTsarBomba.this.countdown;
                case 1 -> (int)(TileEntityTheoreticalTsarBomba.this.megaton * 100.0f);
                case 2 -> {
                    if (TileEntityTheoreticalTsarBomba.this.hasExplosive) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> {
                    if (TileEntityTheoreticalTsarBomba.this.hasFuse) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityTheoreticalTsarBomba.this.countdown = value;
                    break;
                }
                case 1: {
                    TileEntityTheoreticalTsarBomba.this.megaton = (float)value / 100.0f;
                    break;
                }
                case 2: {
                    TileEntityTheoreticalTsarBomba.this.hasExplosive = value == 1;
                    break;
                }
                case 3: {
                    TileEntityTheoreticalTsarBomba.this.hasFuse = value == 1;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public TileEntityTheoreticalTsarBomba(BlockPos pos, BlockState state) {
        super((BlockEntityType)RRTileEntities.THEORETICAL_TSAR_BOMB.get(), pos, state);
    }

    public int getContainerSize() {
        return 21;
    }

    protected void loadAdditional(ValueInput p_422403_) {
        super.loadAdditional(p_422403_);
        ContainerHelper.loadAllItems((ValueInput)p_422403_, this.chestContents);
    }

    protected void saveAdditional(ValueOutput p_422177_) {
        super.saveAdditional(p_422177_);
        ContainerHelper.saveAllItems((ValueOutput)p_422177_, this.chestContents);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean stillValid(@NotNull Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player, (float)64.0f);
    }

    public List<ItemStack> getRods() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 3; i <= 18; ++i) {
            stacks.add(this.getItem(i));
        }
        return stacks;
    }

    public void setChanged() {
        super.setChanged();
        this.hasTrollface = false;
        this.nuclear = 0;
        for (ItemStack rod : this.getRods()) {
            if (rod.is(RRItems.NUCLEAR_ROD)) {
                ++this.nuclear;
            }
            this.hasTrollface |= rod.is(RRItems.trollmask);
        }
        this.megaton = (float)this.nuclear * 6.25f;
        this.hasFuse = this.getItem(0).is(RRItems.fuse);
        this.hasChip = this.getItem(20).is(RRItems.chip);
        if (this.hasChip && this.getItem(20).has(RRComponents.CHIP_DATA)) {
            ChipData chipData = (ChipData)this.getItem(20).get(RRComponents.CHIP_DATA);
            this.rrteam = chipData.team();
            this.player = chipData.gameProfile();
        }
        this.hasAntennae = this.getItem(1).is(RRItems.antenna) && this.getItem(2).is(RRItems.antenna);
        this.hasExplosive = !this.getItem(19).is(RRBlocks.timedbomb.asItem());
    }

    @Override
    public void tick() {
        boolean sp;
        if (this.level.isClientSide()) {
            sp = Minecraft.getInstance().isLocalServer();
        } else {
            MinecraftServer server = this.level.getServer();
            boolean bl = sp = server.getPlayerCount() == 1;
        }
        if (this.hasFuse && this.hasExplosive && this.hasAntennae && this.hasChip) {
            double dist = 1000000.0;
            if (!sp || RRConfig.SERVER.isStopSelfnukeinSP()) {
                if (this.rrteam == RivalRebelsTeam.OMEGA) {
                    dist = this.getBlockPos().distToLowCornerSqr((double)RivalRebels.round.omegaData.objPos().getX(), (double)this.getBlockPos().getY(), (double)RivalRebels.round.omegaData.objPos().getZ());
                }
                if (this.rrteam == RivalRebelsTeam.SIGMA) {
                    dist = this.getBlockPos().distToLowCornerSqr((double)RivalRebels.round.sigmaData.objPos().getX(), (double)this.getBlockPos().getY(), (double)RivalRebels.round.sigmaData.objPos().getZ());
                }
            }
            if (dist > (double)((RRConfig.SERVER.getTsarBombaStrength() + this.nuclear * this.nuclear + 29) * (RRConfig.SERVER.getTsarBombaStrength() + this.nuclear * this.nuclear + 29))) {
                if (this.countdown > 0) {
                    --this.countdown;
                }
            } else if (!this.level.isClientSide()) {
                this.setItem(0, ItemStack.EMPTY);
                for (Player player : this.level.players()) {
                    player.displayClientMessage((Component)Translations.warning().append(" ").append((Component)this.getLevel().getPlayerByUUID(this.player.getId()).getName().copy().withStyle(ChatFormatting.RED)), false);
                    player.displayClientMessage((Component)Component.translatable((String)"rivalrebels.tsar_bomb_defuse", (Object[])new Object[]{this.rrteam.getBlockName()}), false);
                }
            }
        } else {
            this.countdown = RRConfig.SERVER.getNuclearBombCountdown() * 20;
            if (RRConfig.SERVER.getNuclearBombCountdown() == 0) {
                this.countdown = 10;
            }
        }
        if (this.countdown == 200 && !this.level.isClientSide() && RRConfig.SERVER.getNuclearBombCountdown() > 10) {
            Translations.sendWarningBombWillExplodeMessageToPlayers(this.getLevel());
        }
        if (this.countdown % 20 == 0 && this.countdown <= 200 && RRConfig.SERVER.getNuclearBombCountdown() > 10) {
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)RRSounds.NUKE.get(), SoundSource.BLOCKS, 100.0f, 1.0f);
        }
        if (this.countdown == 0 && this.nuclear != 0 && !this.level.isClientSide()) {
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            this.level.setSkyFlashTime(2);
            float pitch = 0.0f;
            float yaw = ((Direction)this.getBlockState().getValue(BlockTheoreticalTsarBomba.FACING)).toYRot();
            EntityTheoreticalTsar tsar = new EntityTheoreticalTsar(this.level, (float)this.getBlockPos().getX() + 0.5f, (float)this.getBlockPos().getY() + 1.0f, (float)this.getBlockPos().getZ() + 0.5f, yaw, pitch, this.nuclear, this.hasTrollface);
            this.level.addFreshEntity((Entity)tsar);
        }
        if (this.countdown == 0 && this.nuclear == 0) {
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            this.level.explode(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), 4.0f, Level.ExplosionInteraction.NONE);
        }
    }

    protected Component getDefaultName() {
        return Component.literal((String)"Theoretical Tsar Bomba");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.chestContents;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.chestContents = items;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new ContainerTheoreticalTsar(containerId, inventory, (Container)this, this.containerData);
    }
}

