/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sonichronos.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.sonichronos.SonichronosMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SonichronosModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SonichronosMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        SonichronosMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.cantimetravel = message.data.cantimetravel;
                    variables.goodfuture = message.data.goodfuture;
                    variables.sprintTimeTicks = message.data.sprintTimeTicks;
                    variables.targetDimId = message.data.targetDimId;
                    variables.timeTravelTimer = message.data.timeTravelTimer;
                    variables.timeTravelState = message.data.timeTravelState;
                    variables.savedDeltaX = message.data.savedDeltaX;
                    variables.savedDeltaY = message.data.savedDeltaY;
                    variables.savedDeltaZ = message.data.savedDeltaZ;
                    variables.holdW = message.data.holdW;
                    variables.holdA = message.data.holdA;
                    variables.holdD = message.data.holdD;
                    variables.savedMovementSpeed = message.data.savedMovementSpeed;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean cantimetravel = false;
        public boolean goodfuture = false;
        public double sprintTimeTicks = 0.0;
        public String targetDimId = "\"\"";
        public double timeTravelTimer = 0.0;
        public String timeTravelState = "none";
        public double savedDeltaX = 0.0;
        public double savedDeltaY = 0.0;
        public double savedDeltaZ = 0.0;
        public boolean holdW = false;
        public boolean holdA = false;
        public boolean holdD = false;
        public double savedMovementSpeed = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SonichronosMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("cantimetravel", this.cantimetravel);
            nbt.m_128379_("goodfuture", this.goodfuture);
            nbt.m_128347_("sprintTimeTicks", this.sprintTimeTicks);
            nbt.m_128359_("targetDimId", this.targetDimId);
            nbt.m_128347_("timeTravelTimer", this.timeTravelTimer);
            nbt.m_128359_("timeTravelState", this.timeTravelState);
            nbt.m_128347_("savedDeltaX", this.savedDeltaX);
            nbt.m_128347_("savedDeltaY", this.savedDeltaY);
            nbt.m_128347_("savedDeltaZ", this.savedDeltaZ);
            nbt.m_128379_("holdW", this.holdW);
            nbt.m_128379_("holdA", this.holdA);
            nbt.m_128379_("holdD", this.holdD);
            nbt.m_128347_("savedMovementSpeed", this.savedMovementSpeed);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.cantimetravel = nbt.m_128471_("cantimetravel");
            this.goodfuture = nbt.m_128471_("goodfuture");
            this.sprintTimeTicks = nbt.m_128459_("sprintTimeTicks");
            this.targetDimId = nbt.m_128461_("targetDimId");
            this.timeTravelTimer = nbt.m_128459_("timeTravelTimer");
            this.timeTravelState = nbt.m_128461_("timeTravelState");
            this.savedDeltaX = nbt.m_128459_("savedDeltaX");
            this.savedDeltaY = nbt.m_128459_("savedDeltaY");
            this.savedDeltaZ = nbt.m_128459_("savedDeltaZ");
            this.holdW = nbt.m_128471_("holdW");
            this.holdA = nbt.m_128471_("holdA");
            this.holdD = nbt.m_128471_("holdD");
            this.savedMovementSpeed = nbt.m_128459_("savedMovementSpeed");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("sonichronos", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.cantimetravel = original.cantimetravel;
            clone.goodfuture = original.goodfuture;
            clone.sprintTimeTicks = original.sprintTimeTicks;
            clone.targetDimId = original.targetDimId;
            clone.timeTravelTimer = original.timeTravelTimer;
            clone.timeTravelState = original.timeTravelState;
            clone.savedDeltaX = original.savedDeltaX;
            clone.savedDeltaY = original.savedDeltaY;
            clone.savedDeltaZ = original.savedDeltaZ;
            clone.holdW = original.holdW;
            clone.holdA = original.holdA;
            clone.holdD = original.holdD;
            clone.savedMovementSpeed = original.savedMovementSpeed;
            if (!event.isWasDeath()) {
                // empty if block
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }
    }
}

