/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sonichronos.procedures;

import java.util.function.Function;
import net.mcreator.sonichronos.block.TimePostFutureBlock;
import net.mcreator.sonichronos.block.TimePostGoodFutureBlock;
import net.mcreator.sonichronos.block.TimePostPastBlock;
import net.mcreator.sonichronos.init.SonichronosModMobEffects;
import net.mcreator.sonichronos.init.SonichronosModParticleTypes;
import net.mcreator.sonichronos.init.SonichronosModSounds;
import net.mcreator.sonichronos.network.SonichronosModVariables;
import net.mcreator.sonichronos.procedures.TimePostFutureEntityCollidesInTheBlockProcedure;
import net.mcreator.sonichronos.procedures.TimePostGoodFutureEntityCollidesInTheBlockProcedure;
import net.mcreator.sonichronos.procedures.TimePostPastEntityCollidesInTheBlockProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sonichronos", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TimeTravelProcedure {
    private static final ResourceKey<Level> DIM_PAST = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("sonichronos:little_planet_past"));
    private static final ResourceKey<Level> DIM_PRESENT = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("sonichronos:little_planet_present"));
    private static final ResourceKey<Level> DIM_BAD_FUTURE = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("sonichronos:little_planet_bad_future"));
    private static final ResourceKey<Level> DIM_GOOD_FUTURE = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("sonichronos:little_planet_good_future"));

    public static void execute(double x, double y, double z, LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer _player = (ServerPlayer)entity;
        if (world.m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        ResourceKey currentDim = level.m_46472_();
        boolean inVanilla = currentDim == Level.f_46428_ || currentDim == Level.f_46429_ || currentDim == Level.f_46430_;
        ResourceKey<Level> dimPast = DIM_PAST;
        ResourceKey<Level> dimPresent = DIM_PRESENT;
        ResourceKey<Level> dimBadFuture = DIM_BAD_FUTURE;
        ResourceKey<Level> dimGoodFuture = DIM_GOOD_FUTURE;
        boolean inLittlePlanet = currentDim == dimPast || currentDim == dimPresent || currentDim == dimBadFuture || currentDim == dimGoodFuture;
        SonichronosModVariables.PlayerVariables playerVars = (SonichronosModVariables.PlayerVariables)entity.getCapability(SonichronosModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SonichronosModVariables.PlayerVariables());
        boolean canTimeTravel = playerVars.cantimetravel;
        double sprintTicks = playerVars.sprintTimeTicks;
        boolean goodFuture = playerVars.goodfuture;
        String state = playerVars.timeTravelState;
        if (!state.equals("none") && (playerVars.timeTravelTimer < 0.0 || playerVars.targetDimId == null || playerVars.targetDimId.isEmpty())) {
            _player.m_21219_();
            playerVars.timeTravelState = "none";
            playerVars.timeTravelTimer = 0.0;
            playerVars.cantimetravel = false;
            playerVars.sprintTimeTicks = 0.0;
            playerVars.targetDimId = "";
            playerVars.savedDeltaX = 0.0;
            playerVars.savedDeltaY = 0.0;
            playerVars.savedDeltaZ = 0.0;
            playerVars.syncPlayerVariables(entity);
        }
        if (state.equals("none")) {
            _player.m_21195_(MobEffects.f_19609_);
            _player.m_21195_((MobEffect)SonichronosModMobEffects.NULL_MOVEMENT.get());
            _player.m_21195_(MobEffects.f_19606_);
            if (!(playerVars.holdW || playerVars.holdA || playerVars.holdD)) {
                _player.m_21051_(Attributes.f_22279_).m_22100_(0.1);
            }
        } else {
            playerVars.timeTravelTimer -= 1.0;
            if (playerVars.timeTravelTimer <= 0.0) {
                if (state.equals("departing")) {
                    if (!playerVars.targetDimId.isEmpty()) {
                        ResourceLocation targetLoc = new ResourceLocation(playerVars.targetDimId);
                        ResourceKey targetDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)targetLoc);
                        ServerLevel targetLevel = level.m_7654_().m_129880_(targetDim);
                        if (targetLevel != null) {
                            playerVars.timeTravelState = "arriving";
                            playerVars.timeTravelTimer = 1.0;
                            playerVars.syncPlayerVariables(entity);
                            _player.changeDimension(targetLevel, new ITeleporter(){

                                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                                    Entity repositionedEntity = repositionEntity.apply(false);
                                    repositionedEntity.m_6021_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                                    repositionedEntity.m_20256_(Vec3.f_82478_);
                                    repositionedEntity.m_146922_(entity.m_146908_());
                                    repositionedEntity.m_146926_(entity.m_146909_());
                                    if (repositionedEntity instanceof ServerPlayer) {
                                        ServerPlayer newPlayer = (ServerPlayer)repositionedEntity;
                                        newPlayer.m_21195_(MobEffects.f_19609_);
                                        newPlayer.m_21195_((MobEffect)SonichronosModMobEffects.NULL_MOVEMENT.get());
                                        newPlayer.m_21195_(MobEffects.f_19606_);
                                        destWorld.m_8767_((ParticleOptions)ParticleTypes.f_123747_, newPlayer.m_20185_(), newPlayer.m_20186_() + 1.0, newPlayer.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                                        destWorld.m_8767_((ParticleOptions)((SimpleParticleType)SonichronosModParticleTypes.TIME_BOOM.get()), newPlayer.m_20185_(), newPlayer.m_20186_() + 1.0, newPlayer.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                                        destWorld.m_6263_(null, newPlayer.m_20185_(), newPlayer.m_20186_(), newPlayer.m_20189_(), (SoundEvent)SonichronosModSounds.TIMETRAVELCOMING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                                        newPlayer.m_6858_(true);
                                    }
                                    return repositionedEntity;
                                }
                            });
                        } else {
                            _player.m_21219_();
                            playerVars.timeTravelState = "none";
                            playerVars.timeTravelTimer = 0.0;
                            playerVars.cantimetravel = false;
                            playerVars.sprintTimeTicks = 0.0;
                            playerVars.targetDimId = "";
                            playerVars.syncPlayerVariables(entity);
                        }
                    }
                } else if (state.equals("arriving")) {
                    playerVars.timeTravelState = "none";
                    playerVars.timeTravelTimer = 0.0;
                    _player.m_21195_(MobEffects.f_19609_);
                    _player.m_21195_((MobEffect)SonichronosModMobEffects.NULL_MOVEMENT.get());
                    _player.m_21195_(MobEffects.f_19606_);
                    canTimeTravel = false;
                    playerVars.cantimetravel = false;
                    playerVars.sprintTimeTicks = 0.0;
                    playerVars.targetDimId = "";
                    _player.m_21051_(Attributes.f_22279_).m_22100_(playerVars.savedMovementSpeed);
                    double savedDeltaHoriz = Math.sqrt(playerVars.savedDeltaX * playerVars.savedDeltaX + playerVars.savedDeltaZ * playerVars.savedDeltaZ);
                    double attributeSpeed = playerVars.savedMovementSpeed * 1.3;
                    double savedSpeed = Math.max(savedDeltaHoriz, attributeSpeed * 0.546);
                    savedSpeed *= 4.0;
                    Vec3 look = _player.m_20154_();
                    double lookHoriz = Math.sqrt(look.f_82479_ * look.f_82479_ + look.f_82481_ * look.f_82481_);
                    if (lookHoriz > 0.0) {
                        double dx = look.f_82479_ / lookHoriz * savedSpeed;
                        double dz = look.f_82481_ / lookHoriz * savedSpeed;
                        _player.m_20334_(dx, playerVars.savedDeltaY, dz);
                    } else {
                        _player.m_20334_(0.0, playerVars.savedDeltaY, 0.0);
                    }
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer _sp = (ServerPlayer)entity;
                        _sp.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(_sp.m_19879_(), _player.m_20184_()));
                    }
                    playerVars.savedDeltaX = 0.0;
                    playerVars.savedDeltaY = 0.0;
                    playerVars.savedDeltaZ = 0.0;
                    playerVars.syncPlayerVariables(entity);
                }
            }
            if (!playerVars.timeTravelState.equals("none")) {
                _player.m_20256_(Vec3.f_82478_);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer _sp = (ServerPlayer)entity;
                    _sp.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(_sp.m_19879_(), Vec3.f_82478_));
                }
                _player.m_6858_(true);
                _player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 40, 0, false, false));
                _player.m_7292_(new MobEffectInstance((MobEffect)SonichronosModMobEffects.NULL_MOVEMENT.get(), 35, 0, false, false));
                _player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 4, false, false));
            }
        }
        if (canTimeTravel && state.equals("none")) {
            Vec3 delta = _player.m_20184_();
            if (playerVars.holdW || playerVars.holdA || playerVars.holdD) {
                if ((sprintTicks += 1.0) == 20.0) {
                    level.m_6263_(null, _player.m_20185_(), _player.m_20186_(), _player.m_20189_(), (SoundEvent)SonichronosModSounds.CD_TIME_TRAVEL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (sprintTicks >= 20.0 && sprintTicks < 140.0) {
                    double playerSpeed = Math.sqrt(_player.m_20184_().f_82479_ * _player.m_20184_().f_82479_ + _player.m_20184_().f_82481_ * _player.m_20184_().f_82481_);
                    int particleCount = Math.min((int)(3.0 + playerSpeed * 20.0), 50);
                    double particleSpeed = 0.05 + playerSpeed * 0.5;
                    for (int i = 0; i < particleCount; ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)particleCount + sprintTicks * 0.2;
                        double offX = Math.cos(angle) * 0.3;
                        double offZ = Math.sin(angle) * 0.3;
                        level.m_8767_((ParticleOptions)((SimpleParticleType)SonichronosModParticleTypes.SPARK.get()), _player.m_20185_() + offX, _player.m_20186_() + 0.5, _player.m_20189_() + offZ, 1, 0.0, 0.0, 0.0, particleSpeed);
                    }
                }
                if (sprintTicks == 125.0) {
                    playerVars.savedDeltaX = _player.m_20184_().f_82479_;
                    playerVars.savedDeltaY = _player.m_20184_().f_82480_;
                    playerVars.savedDeltaZ = _player.m_20184_().f_82481_;
                    if (Math.abs(_player.m_20184_().f_82480_ + 0.0784) < 1.0E-4) {
                        playerVars.savedDeltaY = 0.0;
                    }
                    playerVars.savedMovementSpeed = _player.m_21133_(Attributes.f_22279_);
                    playerVars.syncPlayerVariables(entity);
                }
                if (sprintTicks >= 140.0) {
                    playerVars.timeTravelState = "departing";
                    playerVars.timeTravelTimer = 30.0;
                    playerVars.syncPlayerVariables(entity);
                    _player.m_6021_(_player.m_20185_(), _player.m_20186_() + 0.25, _player.m_20189_());
                    _player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 60, 0, false, false));
                    _player.m_7292_(new MobEffectInstance((MobEffect)SonichronosModMobEffects.NULL_MOVEMENT.get(), 60, 0, false, false));
                    _player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60, 4, false, false));
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, _player.m_20185_(), _player.m_20186_() + 1.0, _player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    level.m_8767_((ParticleOptions)((SimpleParticleType)SonichronosModParticleTypes.TIME_BOOM.get()), _player.m_20185_(), _player.m_20186_() + 1.0, _player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    _player.m_6858_(true);
                    sprintTicks = 0.0;
                }
            } else if (sprintTicks > 0.0) {
                canTimeTravel = false;
                sprintTicks = 0.0;
                playerVars.targetDimId = "";
                _player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(((SoundEvent)SonichronosModSounds.CD_TIME_TRAVEL.get()).m_11660_(), SoundSource.PLAYERS));
                _player.m_21195_(MobEffects.f_19609_);
                _player.m_21195_((MobEffect)SonichronosModMobEffects.NULL_MOVEMENT.get());
                _player.m_21195_(MobEffects.f_19606_);
            }
        }
        if (state.equals("none")) {
            boolean isTimePost = false;
            boolean isTimePostPast = false;
            boolean isTimePostFuture = false;
            boolean isTimePostGoodFuture = false;
            if (!canTimeTravel) {
                for (int dx = -1; dx <= 0; ++dx) {
                    for (int dz = -1; dz <= 0; ++dz) {
                        BlockPos checkPos = new BlockPos((int)x + dx, (int)y, (int)z + dz);
                        BlockState checkState = level.m_8055_(checkPos);
                        Block checkBlock = checkState.m_60734_();
                        if (checkBlock instanceof TimePostPastBlock) {
                            isTimePostPast = true;
                            isTimePost = true;
                            TimePostPastEntityCollidesInTheBlockProcedure.execute(world, checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_(), entity);
                            break;
                        }
                        if (checkBlock instanceof TimePostFutureBlock) {
                            isTimePostFuture = true;
                            isTimePost = true;
                            TimePostFutureEntityCollidesInTheBlockProcedure.execute(world, checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_(), entity);
                            break;
                        }
                        if (!(checkBlock instanceof TimePostGoodFutureBlock)) continue;
                        isTimePostGoodFuture = true;
                        isTimePost = true;
                        TimePostGoodFutureEntityCollidesInTheBlockProcedure.execute(world, checkPos.m_123341_(), checkPos.m_123342_(), checkPos.m_123343_(), entity);
                        break;
                    }
                    if (isTimePost) break;
                }
            }
            if (inLittlePlanet && isTimePost) {
                ResourceKey<Level> targetDim = null;
                if (currentDim == dimPresent) {
                    if (isTimePostPast) {
                        targetDim = dimPast;
                    } else if (isTimePostFuture) {
                        targetDim = goodFuture ? dimGoodFuture : dimBadFuture;
                    } else if (isTimePostGoodFuture) {
                        targetDim = dimGoodFuture;
                    }
                } else if (currentDim == dimPast) {
                    if (isTimePostFuture) {
                        targetDim = dimPresent;
                    }
                } else if ((currentDim == dimBadFuture || currentDim == dimGoodFuture) && isTimePostPast) {
                    targetDim = dimPresent;
                }
                if (targetDim != null) {
                    canTimeTravel = true;
                    playerVars.targetDimId = targetDim.m_135782_().toString();
                }
            }
            if (inVanilla && isTimePost) {
                canTimeTravel = true;
                playerVars.targetDimId = dimPresent.m_135782_().toString();
            }
        }
        playerVars.cantimetravel = canTimeTravel;
        playerVars.sprintTimeTicks = sprintTicks;
        playerVars.syncPlayerVariables(entity);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_()) {
            Player player = event.player;
            Level world = player.m_9236_();
            double x = player.m_20185_();
            double y = player.m_20186_();
            double z = player.m_20189_();
            Player entity = player;
            TimeTravelProcedure.execute(x, y, z, (LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(SonichronosModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(oldVars -> event.getEntity().getCapability(SonichronosModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(newVars -> {
                newVars.timeTravelState = oldVars.timeTravelState;
                newVars.timeTravelTimer = oldVars.timeTravelTimer;
                newVars.targetDimId = oldVars.targetDimId;
                newVars.savedDeltaX = oldVars.savedDeltaX;
                newVars.savedDeltaY = oldVars.savedDeltaY;
                newVars.savedDeltaZ = oldVars.savedDeltaZ;
                newVars.savedMovementSpeed = oldVars.savedMovementSpeed;
                newVars.cantimetravel = oldVars.cantimetravel;
                newVars.sprintTimeTicks = oldVars.sprintTimeTicks;
                newVars.goodfuture = oldVars.goodfuture;
                newVars.holdW = oldVars.holdW;
                newVars.holdA = oldVars.holdA;
                newVars.holdD = oldVars.holdD;
                newVars.syncPlayerVariables((Entity)event.getEntity());
            }));
            event.getOriginal().invalidateCaps();
        }
    }
}

