/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sonichronos.entity;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.mcreator.sonichronos.block.entity.BossPostTileEntity;
import net.mcreator.sonichronos.init.SonichronosModEntities;
import net.mcreator.sonichronos.init.SonichronosModParticleTypes;
import net.mcreator.sonichronos.init.SonichronosModSounds;
import net.mcreator.sonichronos.network.SonichronosModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class EGGHVC001Entity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(EGGHVC001Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(EGGHVC001Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(EGGHVC001Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private long lastSwing;
    public String animationprocedure = "empty";
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private BossState currentState = BossState.NORMAL;
    private int stateTimer = 0;
    private int cooldownTimer = 0;
    private BlockPos spawnBlockPos;
    private int attackAttempts = 0;
    private int attackTick = 0;
    private final HashMap<Player, Integer> collisionCooldowns = new HashMap();
    private boolean lowHealth = false;
    private boolean isEntrancePhase = true;
    private int spawnTimer = 0;
    private boolean allowPlayerHurt = false;
    private Map<UUID, Long> playerMusicTimes = new HashMap<UUID, Long>();
    private Map<UUID, ResourceLocation> playerAmbients = new HashMap<UUID, ResourceLocation>();
    String prevAnim = "empty";

    public EGGHVC001Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<EGGHVC001Entity>)((EntityType)SonichronosModEntities.EGGHVC_001.get()), world);
    }

    public EGGHVC001Entity(EntityType<EGGHVC001Entity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(2.0f);
        this.f_21365_ = new CustomLookControl((Mob)this);
        if (!world.f_46443_) {
            this.setAnimation("entrance");
            this.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 120, 0, false, false));
        }
    }

    public void addPlayerMusicTime(UUID uuid, long time) {
        this.playerMusicTimes.put(uuid, time);
    }

    public void addPlayerAmbient(UUID uuid, ResourceLocation id) {
        this.playerAmbients.put(uuid, id);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ++this.spawnTimer;
            if (this.isEntrancePhase && this.spawnTimer >= 100) {
                this.isEntrancePhase = false;
                this.m_21195_(MobEffects.f_19591_);
            }
            if (!this.isEntrancePhase && this.spawnTimer < 100) {
                this.setAnimation("entrance");
            }
            if (this.f_19797_ % 20 == 0) {
                List nearby = ((ServerLevel)this.m_9236_()).m_8795_(p -> this.m_20280_((Entity)p) < 4096.0);
                for (ServerPlayer player : nearby) {
                    Optional opt;
                    UUID uuid = player.m_20148_();
                    long last = this.playerMusicTimes.getOrDefault(uuid, 0L);
                    long now = this.m_9236_().m_46467_();
                    if (now - last < 1560L && last != 0L) continue;
                    if (last == 0L && (opt = ((Biome)this.m_9236_().m_204166_(player.m_20183_()).m_203334_()).m_47557_().m_47993_()).isPresent()) {
                        Holder holder = (Holder)opt.get();
                        ResourceLocation id = ((SoundEvent)holder.m_203334_()).m_11660_();
                        player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(id, SoundSource.AMBIENT));
                        this.addPlayerAmbient(uuid, id);
                    }
                    ResourceLocation bossLoc = ((SoundEvent)SonichronosModSounds.BOSS.get()).m_11660_();
                    ResourceKey bossKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256840_, (ResourceLocation)bossLoc);
                    Holder.Reference bossHolder = ((ServerLevel)this.m_9236_()).m_9598_().m_175515_(Registries.f_256840_).m_246971_(bossKey);
                    player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)bossHolder, SoundSource.MASTER, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.7f, 1.0f, this.m_9236_().m_213780_().m_188505_()));
                    this.playerMusicTimes.put(uuid, now);
                }
            }
        }
    }

    public void m_6667_(DamageSource source) {
        ServerLevelAccessor _level;
        BlockEntity blockEntity;
        Level bossId;
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SonichronosModSounds.DESTROYED.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            for (int i = 0; i < 10; ++i) {
                double dx = this.f_19796_.m_188583_() * 0.2;
                double dy = this.f_19796_.m_188583_() * 0.2;
                double dz = this.f_19796_.m_188583_() * 0.2;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SonichronosModParticleTypes.BOSS_EXPLOSION.get()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, dx, dy, dz, 0.5);
            }
            bossId = ((SoundEvent)SonichronosModSounds.BOSS.get()).m_11660_();
            List nearby = ((ServerLevel)this.m_9236_()).m_8795_(p -> this.m_20280_((Entity)p) < 4096.0);
            for (ServerPlayer player : nearby) {
                ResourceLocation ambientId;
                UUID uuid = player.m_20148_();
                if (bossId != null) {
                    player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket((ResourceLocation)bossId, SoundSource.MASTER));
                }
                if ((ambientId = this.playerAmbients.get(uuid)) == null) continue;
                ResourceKey ambientKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256840_, (ResourceLocation)ambientId);
                Holder.Reference ambientHolder = ((ServerLevel)this.m_9236_()).m_9598_().m_175515_(Registries.f_256840_).m_246971_(ambientKey);
                player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)ambientHolder, SoundSource.AMBIENT, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, this.m_9236_().m_213780_().m_188505_()));
            }
        }
        super.m_6667_(source);
        if (this.spawnBlockPos != null && (bossId = this.m_9236_()) instanceof ServerLevelAccessor && (blockEntity = (_level = (ServerLevelAccessor)bossId).m_7702_(this.spawnBlockPos)) instanceof BossPostTileEntity) {
            BossPostTileEntity bossTileEntity = (BossPostTileEntity)blockEntity;
            bossTileEntity.setBossAlive(false);
            bossTileEntity.setRespawnTime(_level.m_6018_().m_46467_() + 100L);
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"eggmobilecd");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public void setSpawnBlockPos(BlockPos pos) {
        this.spawnBlockPos = pos;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BossSpecialBehaviorGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)SonichronosModSounds.HIT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player && !this.allowPlayerHurt) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        if (this.spawnBlockPos != null) {
            compound.m_128405_("SpawnX", this.spawnBlockPos.m_123341_());
            compound.m_128405_("SpawnY", this.spawnBlockPos.m_123342_());
            compound.m_128405_("SpawnZ", this.spawnBlockPos.m_123343_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("SpawnX")) {
            this.spawnBlockPos = new BlockPos(compound.m_128451_("SpawnX"), compound.m_128451_("SpawnY"), compound.m_128451_("SpawnZ"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.m_9236_().m_5776_() && !this.m_21224_()) {
            this.collisionCooldowns.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
            this.collisionCooldowns.forEach((player, cooldown) -> this.collisionCooldowns.put((Player)player, cooldown - 1));
            List players = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(2.0));
            for (Player player2 : players) {
                if (!this.m_20191_().m_82381_(player2.m_20191_()) || this.collisionCooldowns.containsKey(player2) && this.collisionCooldowns.get(player2) > 0 || this.m_5448_() == player2 && this.attackTick > 15) continue;
                boolean playerOnGround = ((SonichronosModVariables.PlayerVariables)player2.getCapability(SonichronosModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new SonichronosModVariables.PlayerVariables())).playerOnGround;
                Vec3 horizontalToPlayer = new Vec3(player2.m_20185_() - this.m_20185_(), 0.0, player2.m_20189_() - this.m_20189_()).m_82541_();
                Vec3 horizontalLook = new Vec3(this.m_20154_().f_82479_, 0.0, this.m_20154_().f_82481_).m_82541_();
                double dot = horizontalLook.m_82526_(horizontalToPlayer);
                if (dot > 0.5 && player2.m_20186_() > this.m_20186_() + 1.0 && !playerOnGround) {
                    double strength = 1.0;
                    double upward = 0.3;
                    player2.m_5997_(horizontalToPlayer.f_82479_ * strength, upward, horizontalToPlayer.f_82481_ * strength);
                    player2.f_19864_ = true;
                    this.setAnimation("bounceattack");
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SonichronosModSounds.SPRING.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                    this.collisionCooldowns.put(player2, 20);
                    continue;
                }
                if (!(dot < -0.5) || playerOnGround) continue;
                this.allowPlayerHurt = true;
                this.m_6469_(this.m_9236_().m_269111_().m_269075_(player2), 8.0f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SonichronosModSounds.HIT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                if (this.m_21223_() <= 0.0f) {
                    this.m_6667_(this.m_9236_().m_269111_().m_269075_(player2));
                }
                this.allowPlayerHurt = false;
                this.collisionCooldowns.put(player2, 20);
            }
            if (this.cooldownTimer > 0) {
                --this.cooldownTimer;
            }
            this.m_6210_();
            if (this.lowHealth) {
                this.m_6858_(true);
            } else {
                this.m_6858_(false);
            }
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.0f);
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (!this.lowHealth && this.m_21223_() <= this.m_21233_() / 2.0f) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.4);
            this.lowHealth = true;
        }
        if (this.attackTick > 0) {
            --this.attackTick;
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.currentState == BossState.NORMAL) {
                ++this.attackAttempts;
            }
        }
        return flag;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.32);
        builder = builder.m_22268_(Attributes.f_22276_, 100.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.m_21224_()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("death"));
        }
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() && !this.lowHealth) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (event.isMoving() && this.lowHealth) {
                event.getController().forceAnimationReset();
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 10L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 60) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 0, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_5448_() != null) {
            Vec3 look = this.m_20154_().m_82541_().m_82541_();
            Vec3 smoothed = new Vec3(travelVector.f_82479_ * 1.0, travelVector.f_82480_, travelVector.f_82481_ * 1.0);
            super.m_7023_(smoothed);
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SonichronosModSounds.MECHSTEP.get(), 0.3f, 1.0f);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level){

            protected PathFinder m_5532_(int pMaxVisitedNodes) {
                this.f_26508_ = new WalkNodeEvaluator(){

                    public BlockPathTypes m_7209_(BlockGetter pLevel, int pX, int pY, int pZ, Mob pMob) {
                        BlockPathTypes type = super.m_7209_(pLevel, pX, pY, pZ, pMob);
                        if (type == BlockPathTypes.WATER || type == BlockPathTypes.WATER_BORDER) {
                            return BlockPathTypes.DANGER_OTHER;
                        }
                        return type;
                    }
                };
                return new PathFinder(this.f_26508_, pMaxVisitedNodes);
            }
        };
    }

    private static enum BossState {
        NORMAL,
        BACKING_AWAY,
        MAD;

    }

    private class CustomLookControl
    extends LookControl {
        public CustomLookControl(Mob mob) {
            super(mob);
            this.f_24938_ = 1.0E-6f;
            this.f_24939_ = 1.0E-6f;
        }
    }

    private class BossSpecialBehaviorGoal
    extends Goal {
        private final EGGHVC001Entity entity;

        public BossSpecialBehaviorGoal(EGGHVC001Entity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.entity.m_5448_() != null;
        }

        public boolean m_8045_() {
            return this.entity.m_5448_() != null;
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (target != null) {
                this.entity.m_21563_().m_148051_((Entity)target);
                if (this.entity.currentState == BossState.BACKING_AWAY) {
                    if (this.entity.stateTimer > 0) {
                        --this.entity.stateTimer;
                        Vec3 direction = this.entity.m_20182_().m_82546_(target.m_20182_()).m_82541_();
                        Vec3 wantedPos = this.entity.m_20182_().m_82549_(direction.m_82490_(1.5));
                        if (this.entity.m_9236_().m_6425_(BlockPos.m_274446_((Position)wantedPos)).m_205070_(FluidTags.f_13131_)) {
                            Vec3 leftDir = direction.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
                            Vec3 leftPos = this.entity.m_20182_().m_82549_(leftDir.m_82490_(1.5));
                            if (!this.entity.m_9236_().m_6425_(BlockPos.m_274446_((Position)leftPos)).m_205070_(FluidTags.f_13131_)) {
                                wantedPos = leftPos;
                            } else {
                                Vec3 rightPos = this.entity.m_20182_().m_82549_(leftDir.m_82490_(-1.5));
                                if (!this.entity.m_9236_().m_6425_(BlockPos.m_274446_((Position)rightPos)).m_205070_(FluidTags.f_13131_)) {
                                    wantedPos = rightPos;
                                }
                            }
                        }
                        this.entity.m_21573_().m_26519_(wantedPos.f_82479_, wantedPos.f_82480_, wantedPos.f_82481_, 0.8);
                    } else {
                        this.entity.currentState = BossState.MAD;
                        this.entity.stateTimer = 40;
                        this.entity.setAnimation("mad");
                        this.entity.m_9236_().m_6263_(null, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), this.entity.m_7975_(null), SoundSource.HOSTILE, 1.0f, 1.0f);
                        this.entity.m_21573_().m_26573_();
                        this.entity.m_20256_(Vec3.f_82478_);
                    }
                } else if (this.entity.currentState == BossState.MAD) {
                    if (this.entity.stateTimer > 0) {
                        --this.entity.stateTimer;
                        this.entity.setAnimation("mad");
                        this.entity.m_21391_((Entity)target, 1.0f, 1.0f);
                    } else {
                        this.entity.currentState = BossState.NORMAL;
                        this.entity.setAnimation("empty");
                        this.entity.cooldownTimer = 60;
                        this.entity.attackAttempts = 0;
                    }
                } else if (this.entity.currentState == BossState.NORMAL) {
                    this.entity.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
                    double reach = this.entity.m_20205_() * 1.0f * this.entity.m_20205_() * 1.0f + target.m_20205_();
                    if (this.entity.m_20280_((Entity)target) <= reach && this.entity.attackTick <= 0 && target.m_20186_() <= this.entity.m_20186_() + 1.5) {
                        this.entity.attackTick = 20;
                        this.entity.m_6674_(InteractionHand.MAIN_HAND);
                        this.entity.m_7327_((Entity)target);
                        ++this.entity.attackAttempts;
                    }
                    if (this.entity.cooldownTimer == 0 && this.entity.m_20280_((Entity)target) < 9.0 && this.entity.attackAttempts >= 3) {
                        this.entity.currentState = BossState.BACKING_AWAY;
                        this.entity.stateTimer = 60;
                        this.entity.setAnimation("walk_backwards");
                        this.entity.attackAttempts = 0;
                    }
                }
            }
        }
    }
}

