/*
 * Decompiled with CFR 0.152.
 */
package io.p2vman.eptalistmod;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.p2vman.eptalistmod.Config;
import io.p2vman.eptalistmod.storge.Data;
import io.p2vman.eptalistmod.storge.Storge;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public final class Eptalistmod {
    public static final Logger LOGGER = Logger.getLogger("EptaList");
    public static final String MOD_ID = "eptalistmod";
    public static Config.ConfigContainer config;
    public static Data<String> list;
    public static Config.Mode mode;
    public static List<ResourceLocation> identifiers;
    public static final Component WHITELIST_ON;
    public static final Component WHITELIST_OFF;

    public static void init() {
        config.load();
        identifiers.clear();
        for (Config.Mode mode1 : Eptalistmod.config.get().modes) {
            identifiers.add(mode1.id);
        }
        ResourceLocation id = Eptalistmod.config.get().curent;
        for (Config.Mode mode1 : Eptalistmod.config.get().modes) {
            if (!mode1.id.equals((Object)id)) continue;
            mode = mode1;
            break;
        }
        try {
            list = Storge.find(Eptalistmod.mode.storage).getConstructor(Map.class).newInstance(Eptalistmod.mode.data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.log(Level.INFO, "Mod Configuration Loaded.");
    }

    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"eptalist").requires(ctx -> ctx.m_6761_(2))).then(Commands.m_82127_((String)"off").executes(ctx -> {
            Eptalistmod.config.get().enable = false;
            ((CommandSourceStack)ctx.getSource()).m_81354_(WHITELIST_OFF, true);
            return 1;
        }))).then(Commands.m_82127_((String)"on").executes(ctx -> {
            Eptalistmod.config.get().enable = true;
            ((CommandSourceStack)ctx.getSource()).m_81354_(WHITELIST_ON, true);
            return 1;
        }))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> {
            TextComponent component = new TextComponent("");
            for (GameProfile profile : GameProfileArgument.m_94590_((CommandContext)ctx, (String)"players")) {
                boolean b = list.addUser(profile.getName());
                component.m_7220_((Component)new TextComponent(profile.getName()).m_130940_(b ? ChatFormatting.GREEN : ChatFormatting.RED)).m_130946_(" ");
            }
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Add: ").m_7220_((Component)component).m_130946_("."), true);
            return 1;
        })))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).executes(ctx -> {
            TextComponent component = new TextComponent("");
            for (GameProfile profile : GameProfileArgument.m_94590_((CommandContext)ctx, (String)"players")) {
                boolean b = list.removeUser(profile.getName());
                component.m_7220_((Component)new TextComponent(profile.getName()).m_130940_(b ? ChatFormatting.GREEN : ChatFormatting.RED)).m_130946_(" ");
            }
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Removed: ").m_7220_((Component)component).m_130946_("."), true);
            return 1;
        })))).then(Commands.m_82127_((String)"list").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent(list.toList().toString()), false);
            return 1;
        }))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            try {
                Eptalistmod.init();
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Reload Success."), true);
            }
            catch (Exception e) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Reload Fail."), true);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"mode").then(Commands.m_82129_((String)"mode", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ctx -> {
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"mode");
            if (identifiers.contains(id)) {
                Eptalistmod.config.get().curent = id;
                config.save();
                Eptalistmod.init();
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TextComponent("Mode set to: ").m_130946_(id.toString()), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TextComponent("Invalid mode ID!"));
            }
            return 1;
        }))));
    }

    static {
        identifiers = new ObjectArrayList();
        WHITELIST_ON = new TextComponent("Whitelist ").m_7220_((Component)new TextComponent("on").m_130940_(ChatFormatting.GREEN).m_130946_("."));
        WHITELIST_OFF = new TextComponent("Whitelist ").m_7220_((Component)new TextComponent("off").m_130940_(ChatFormatting.RED).m_130946_("."));
    }
}

