/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.bounge;

import com.google.gson.JsonObject;
import io.github.p2vman.Identifier;
import io.github.p2vman.eptalist.Config;
import io.github.p2vman.eptalist.bounge.Event;
import io.github.p2vman.eptalist.bounge.WhiteListCommand;
import io.github.p2vman.eptalist.bounge.metrics.Metrics;
import io.github.p2vman.eptalist.metrics.SimplePie;
import io.github.p2vman.eptalist.storge.Data;
import io.github.p2vman.eptalist.storge.Storge;
import io.github.p2vman.profiling.ExempleProfiler;
import io.github.p2vman.profiling.Profiler;
import io.github.p2vman.updater.Updater;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;

public final class Boungecord
extends Plugin {
    public static final Logger LOGGER = Logger.getLogger("EptaList");
    public static final Profiler profiler = new ExempleProfiler();
    public static Config.ConfigContainer config;
    public static Data<String> list;
    public static Config.Mode mode;
    public static List<Identifier> identifiers;

    public static void load() {
        profiler.push("load");
        config.load();
        identifiers.clear();
        for (Config.Mode mode1 : Boungecord.config.get().modes) {
            identifiers.add(mode1.id);
        }
        Identifier id = Boungecord.config.get().curent;
        for (Config.Mode mode1 : Boungecord.config.get().modes) {
            if (!mode1.id.equals(id)) continue;
            mode = mode1;
            break;
        }
        try {
            list = Storge.find(Boungecord.mode.storage).getConstructor(Map.class).newInstance(Boungecord.mode.data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.log(Level.INFO, String.format("Load Plugin Configuration %sms", profiler.getElapsedTimeAndRemove(profiler.pop())));
    }

    public void onEnable() {
        File data = this.getDataFolder();
        if (!data.exists()) {
            data.mkdirs();
        }
        config = new Config.ConfigContainer(new File(data, "config.cfg"));
        Boungecord.load();
        if (Boungecord.config.get().auto_update_check) {
            try {
                Updater updater = Updater.getInstance();
                JsonObject obj = updater.getLasted();
                if (!this.getDescription().getVersion().equals(obj.get("name").getAsString())) {
                    LOGGER.log(Level.WARNING, "---------- Outdated Version ----------");
                    LOGGER.log(Level.WARNING, "");
                    LOGGER.log(Level.WARNING, "new version:");
                    LOGGER.log(Level.WARNING, updater.getVersionUrl());
                    LOGGER.log(Level.WARNING, "");
                    LOGGER.log(Level.WARNING, "---------------------------------");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Metrics metrics = new Metrics(this, 24527);
        metrics.addCustomChart(new SimplePie("data_type", () -> Boungecord.mode.storage));
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new Event());
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new WhiteListCommand());
    }

    public void onDisable() {
    }

    static {
        identifiers = new ArrayList<Identifier>();
    }
}

