/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.bounge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.p2vman.Identifier;
import io.github.p2vman.eptalist.bounge.Boungecord;
import io.github.p2vman.lang.Lang;
import io.github.p2vman.updater.Updater;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class WhiteListCommand
extends Command
implements TabExecutor {
    private final String[] w1 = new String[]{"off", "on", "add", "remove", "list", "help", "mode", "reload", "info"};

    public WhiteListCommand() {
        super(Boungecord.config.get().command.getPath());
    }

    public void execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.sendMessage((BaseComponent)new TextComponent("/eptalist (" + String.join((CharSequence)"/", this.w1) + ")"));
            return;
        }
        switch (args[0].toLowerCase()) {
            case "off": {
                Boungecord.config.get().enable = false;
                Boungecord.config.save();
                sender.sendMessage((BaseComponent)new TextComponent(Lang.LANG.format("command.off", new Object[0])));
                break;
            }
            case "on": {
                Boungecord.config.get().enable = true;
                Boungecord.config.save();
                sender.sendMessage((BaseComponent)new TextComponent(Lang.LANG.format("command.on", new Object[0])));
                break;
            }
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage((BaseComponent)new TextComponent("Usage: /eptalist add <username>"));
                    break;
                }
                String usernameToAdd = args[1];
                if (!Boungecord.list.addUser(usernameToAdd, t -> sender.sendMessage((BaseComponent)new TextComponent(t)))) break;
                sender.sendMessage((BaseComponent)new TextComponent(Lang.LANG.format("command.add.succes", usernameToAdd)));
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage((BaseComponent)new TextComponent("Usage: /eptalist remove <username>"));
                    break;
                }
                String usernameToRemove = args[1];
                if (!Boungecord.list.removeUser(usernameToRemove, t -> sender.sendMessage((BaseComponent)new TextComponent(t)))) break;
                sender.sendMessage((BaseComponent)new TextComponent(Lang.LANG.format("command.remove.succes", usernameToRemove)));
                break;
            }
            case "list": {
                sender.sendMessage((BaseComponent)new TextComponent("Whitelisted players: " + Boungecord.list.toList()));
                break;
            }
            case "mode": {
                if (args.length < 2) {
                    sender.sendMessage((BaseComponent)new TextComponent("Usage: /eptalist mode <ID>"));
                    break;
                }
                Identifier id = Identifier.tryParse(args[1]);
                if (Boungecord.identifiers.contains(id)) {
                    Boungecord.config.get().curent = id;
                    Boungecord.config.save();
                    Boungecord.load();
                    sender.sendMessage((BaseComponent)new TextComponent(Lang.LANG.format("command.mode.succes", id)));
                    break;
                }
                sender.sendMessage((BaseComponent)new TextComponent(Lang.LANG.format("command.mode.invalid.id", new Object[0])));
                break;
            }
            case "help": {
                sender.sendMessage((BaseComponent)new TextComponent(String.join((CharSequence)"\n", "1: /eptalist add <username> - Add user to whitelist", "2: /eptalist remove <username> - Remove user from whitelist", "3: /eptalist list - Display whitelisted players", "4: /eptalist on - Enable whitelist", "5: /eptalist off - Disable whitelist", "6: /eptalist mode <ID> - Set list data mode", "7: /eptalist kick_nolisted - Kick non-whitelisted players", "8: /eptalist reload - Reload the whitelist configuration")));
                break;
            }
            case "reload": {
                try {
                    Boungecord.load();
                    sender.sendMessage((BaseComponent)new TextComponent(Lang.LANG.format("command.reload.succes", new Object[0])));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    sender.sendMessage((BaseComponent)new TextComponent(Lang.LANG.format("command.reload.failed", new Object[0])));
                }
                break;
            }
            case "info": {
                JsonObject object = Updater.getInstance().getJson().getAsJsonObject("info");
                sender.sendMessage((BaseComponent)new TextComponent("links:"));
                for (Map.Entry entry : object.getAsJsonObject("urls").entrySet()) {
                    sender.sendMessage((BaseComponent)new TextComponent((String)entry.getKey() + ": " + ((JsonElement)entry.getValue()).getAsString()));
                }
                sender.sendMessage((BaseComponent)new TextComponent());
                break;
            }
            default: {
                sender.sendMessage((BaseComponent)new TextComponent(Lang.LANG.getOrDefult("command.default")));
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return Arrays.stream(this.w1).filter(cmd -> cmd.startsWith(args[0].toLowerCase())).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

