/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.spigot;

import com.google.gson.JsonObject;
import io.github.p2vman.Identifier;
import io.github.p2vman.eptalist.Config;
import io.github.p2vman.eptalist.metrics.SimplePie;
import io.github.p2vman.eptalist.spigot.Event;
import io.github.p2vman.eptalist.spigot.WhiteListCommand;
import io.github.p2vman.eptalist.spigot.metrics.Metrics;
import io.github.p2vman.eptalist.storge.Data;
import io.github.p2vman.eptalist.storge.Storge;
import io.github.p2vman.lang.Lang;
import io.github.p2vman.profiling.ExempleProfiler;
import io.github.p2vman.profiling.Profiler;
import io.github.p2vman.updater.Updater;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EptaList
extends JavaPlugin {
    private static Metrics metrics;
    public static final Profiler profiler;
    public static final Logger LOGGER;
    public static EptaList instance;
    public static Config.ConfigContainer config;
    public static Data<String> list;
    public static Config.Mode mode;
    public static List<Identifier> identifiers;

    public static EptaList getInstance() {
        return instance;
    }

    public EptaList() {
        instance = this;
    }

    public static void load() {
        profiler.push("load");
        config.load();
        identifiers.clear();
        Lang.LANG.clear();
        Lang.LANG.setFormater((string, args) -> ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(string, args)));
        try {
            Lang.LANG.accept(EptaList.class.getResourceAsStream("/res/" + EptaList.config.get().language + ".json"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Config.Mode mode1 : EptaList.config.get().modes) {
            identifiers.add(mode1.id);
        }
        Identifier id = EptaList.config.get().curent;
        for (Config.Mode mode1 : EptaList.config.get().modes) {
            if (!mode1.id.equals(id)) continue;
            mode = mode1;
            break;
        }
        try {
            list = Storge.find(EptaList.mode.storage).getConstructor(Map.class).newInstance(EptaList.mode.data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.log(Level.INFO, String.format("Load Plugin Configuration %sms", profiler.getElapsedTimeAndRemove(profiler.pop())));
    }

    public void onEnable() {
        profiler.push("init");
        metrics = new Metrics((Plugin)this, 24527);
        File data = this.getDataFolder();
        if (!data.exists()) {
            data.mkdirs();
        }
        config = new Config.ConfigContainer(new File(data, "config.json"));
        EptaList.load();
        if (EptaList.config.get().auto_update_check) {
            try {
                Updater updater = Updater.getInstance();
                JsonObject obj = updater.getLasted();
                if (!this.getDescription().getVersion().equals(obj.get("name").getAsString())) {
                    LOGGER.log(Level.WARNING, "---------- Outdated Version ----------");
                    LOGGER.log(Level.WARNING, "");
                    LOGGER.log(Level.WARNING, "new version:");
                    LOGGER.log(Level.WARNING, updater.getVersionUrl());
                    LOGGER.log(Level.WARNING, "");
                    LOGGER.log(Level.WARNING, "---------------------------------");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap map = (CommandMap)commandMapField.get(Bukkit.getServer());
            WhiteListCommand command = new WhiteListCommand(EptaList.config.get().command);
            map.register(EptaList.config.get().command.getNamespace(), (Command)command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getServer().getPluginManager().registerEvents((Listener)new Event(), (Plugin)this);
        metrics.addCustomChart(new SimplePie("data_type", () -> EptaList.mode.storage));
        LOGGER.log(Level.INFO, String.format("Init Plugin %sms", profiler.getElapsedTimeAndRemove(profiler.pop())));
    }

    public void onDisable() {
        try {
            if (list != null) {
                list.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        profiler = new ExempleProfiler();
        LOGGER = Logger.getLogger("EptaList");
        instance = null;
        identifiers = new ArrayList<Identifier>();
    }
}

