/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.spigot;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.p2vman.Identifier;
import io.github.p2vman.Utils;
import io.github.p2vman.eptalist.spigot.EptaList;
import io.github.p2vman.lang.Lang;
import io.github.p2vman.updater.Updater;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.StringUtil;

public class WhiteListCommand
extends Command {
    private final String[] w1 = new String[]{"off", "on", "add", "remove", "list", "help", "mode", "kick_nolisted", "reload", "info"};
    private final Permission permission_enable;
    private final Permission permission_add;
    private final Permission permission_remove;
    private final Permission permission_reload;
    private final Permission permission_mode;
    private final Permission permission_outher;
    private final Permission permission_list;

    public WhiteListCommand(Identifier identifier) {
        super(identifier.getPath());
        Function<Permission, Permission> recal = p -> {
            p.recalculatePermissibles();
            return p;
        };
        this.permission_enable = recal.apply(new Permission("eptalist.enable", PermissionDefault.OP));
        this.permission_add = recal.apply(new Permission("eptalist.add", PermissionDefault.OP));
        this.permission_remove = recal.apply(new Permission("eptalist.remove", PermissionDefault.OP));
        this.permission_reload = recal.apply(new Permission("eptalist.reload", PermissionDefault.OP));
        this.permission_mode = recal.apply(new Permission("eptalist.mode", PermissionDefault.OP));
        this.permission_list = recal.apply(new Permission("eptalist.list", PermissionDefault.OP));
        this.permission_outher = recal.apply(new Permission("eptalist.outher", PermissionDefault.OP));
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (args.length <= 0) {
            sender.sendMessage(String.format("/%s (%s)", this.getName(), String.join((CharSequence)"/", this.w1)));
            return false;
        }
        switch (args[0]) {
            case "off": {
                if (!this.testPermission(sender, this.permission_enable)) break;
                EptaList.config.get().enable = false;
                EptaList.config.save();
                sender.sendMessage(Lang.LANG.format("command.off", new Object[0]));
                break;
            }
            case "on": {
                if (!this.testPermission(sender, this.permission_enable)) break;
                EptaList.config.get().enable = true;
                EptaList.config.save();
                sender.sendMessage(Lang.LANG.format("command.on", new Object[0]));
                break;
            }
            case "add": {
                if (!this.testPermission(sender, this.permission_add)) break;
                ArrayList info = new ArrayList();
                if (!Utils.len(args, 1)) {
                    sender.sendMessage("Usage: /" + commandLabel + " add <username>");
                    break;
                }
                EptaList.list.addUserAsync(args[1], t -> sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)t))).thenAccept(d -> {
                    if (d.booleanValue()) {
                        sender.sendMessage(Lang.LANG.format("command.add.succes", args[1]));
                    }
                });
                break;
            }
            case "remove": {
                if (!this.testPermission(sender, this.permission_remove)) break;
                if (!Utils.len(args, 1)) {
                    sender.sendMessage("Usage: /" + commandLabel + " remove <username>");
                    break;
                }
                EptaList.list.removeUserAsync(args[1], t -> sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)t))).thenAccept(d -> {
                    if (d.booleanValue()) {
                        sender.sendMessage(Lang.LANG.format("command.remove.succes", args[1]));
                    }
                });
                break;
            }
            case "list": {
                if (!this.testPermission(sender, this.permission_list)) break;
                sender.sendMessage("Whitelisted players: " + EptaList.list.toList().toString());
                break;
            }
            case "mode": {
                if (!this.testPermission(sender, this.permission_mode)) break;
                if (!Utils.len(args, 1)) {
                    sender.sendMessage("Usage: /" + commandLabel + " mode <ID>");
                    break;
                }
                Identifier id = Identifier.tryParse(args[1]);
                if (id != null && EptaList.identifiers.contains(id)) {
                    EptaList.config.get().curent = id;
                    EptaList.config.save();
                    EptaList.load();
                    sender.sendMessage(Lang.LANG.format("command.mode.succes", id));
                    break;
                }
                sender.sendMessage(Lang.LANG.format("command.mode.invalid.id", new Object[0]));
                break;
            }
            case "kick_nolisted": {
                if (!this.testPermission(sender, this.permission_outher)) break;
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    if (EptaList.list.is(player.getName())) continue;
                    player.kickPlayer(EptaList.mode.kick_msg);
                }
                sender.sendMessage("Non-whitelisted players have been kicked.");
                break;
            }
            case "help": {
                sender.sendMessage(new String[]{String.format("1: /%s add <username> - Add user to whitelist", this.getName()), String.format("2: /%s remove <username> - Remove user from whitelist", this.getName()), String.format("3: /%s list - Display whitelisted players", this.getName()), String.format("4: /%s on - Enable whitelist", this.getName()), String.format("5: /%s off - Disable whitelist", this.getName()), String.format("6: /%s mode <ID> - Set list data mode", this.getName()), String.format("7: /%s kick_nolisted - Kick non-whitelisted players", this.getName()), String.format("8: /%s reload - Reload the whitelist configuration", this.getName())});
                break;
            }
            case "reload": {
                if (!this.testPermission(sender, this.permission_reload)) break;
                try {
                    EptaList.load();
                    sender.sendMessage(Lang.LANG.format("command.reload.succes", new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    sender.sendMessage(Lang.LANG.format("command.reload.failed", new Object[0]));
                }
                break;
            }
            case "info": {
                JsonObject object = Updater.getInstance().getJson().getAsJsonObject("info");
                sender.sendMessage("links:");
                for (Map.Entry entry : object.getAsJsonObject("urls").entrySet()) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&2" + (String)entry.getKey() + "&f: &4" + ((JsonElement)entry.getValue()).getAsString())));
                }
                sender.sendMessage("");
                break;
            }
            default: {
                sender.sendMessage(Lang.LANG.getOrDefult("command.default"));
            }
        }
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 0) {
            return ImmutableList.of();
        }
        if (args.length == 1) {
            String lastWord = args[args.length - 1];
            ArrayList<String> matchedPlayers = new ArrayList<String>();
            Iterator var7 = Arrays.stream(this.w1).iterator();
            while (var7.hasNext()) {
                String name = (String)var7.next();
                if (!StringUtil.startsWithIgnoreCase((String)name, (String)lastWord)) continue;
                matchedPlayers.add(name);
            }
            Collections.sort(matchedPlayers, String.CASE_INSENSITIVE_ORDER);
            return matchedPlayers;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("remove")) {
                String lastWord = args[args.length - 1];
                Player senderPlayer = sender instanceof Player ? (Player)sender : null;
                ArrayList<String> matchedPlayers = new ArrayList<String>();
                for (Player player : sender.getServer().getOnlinePlayers()) {
                    String name = player.getName();
                    if (senderPlayer != null && !senderPlayer.canSee(player) || !StringUtil.startsWithIgnoreCase((String)name, (String)lastWord)) continue;
                    matchedPlayers.add(name);
                }
                Collections.sort(matchedPlayers, String.CASE_INSENSITIVE_ORDER);
                return matchedPlayers;
            }
            if (args[0].equalsIgnoreCase("mode")) {
                String lastWord = args[args.length - 1];
                ArrayList<String> matchedPlayers = new ArrayList<String>();
                Iterator<Identifier> var7 = EptaList.identifiers.iterator();
                while (var7.hasNext()) {
                    String name = ((Object)var7.next()).toString();
                    if (!StringUtil.startsWithIgnoreCase((String)name, (String)lastWord)) continue;
                    matchedPlayers.add(name);
                }
                Collections.sort(matchedPlayers, String.CASE_INSENSITIVE_ORDER);
                return matchedPlayers;
            }
        } else if (args.length == 3 && (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("remove"))) {
            String lastWord = args[args.length - 1];
            ArrayList<String> matchedPlayers = new ArrayList<String>();
            Iterator<Identifier> var7 = EptaList.identifiers.iterator();
            while (var7.hasNext()) {
                String name = ((Object)var7.next()).toString();
                if (!StringUtil.startsWithIgnoreCase((String)name, (String)lastWord)) continue;
                matchedPlayers.add(name);
            }
            Collections.sort(matchedPlayers, String.CASE_INSENSITIVE_ORDER);
            return matchedPlayers;
        }
        return ImmutableList.of();
    }

    public boolean testPermission(CommandSender target, Permission permission) {
        if (target.hasPermission(permission.getName())) {
            return true;
        }
        target.sendMessage(Lang.LANG.format("perm.throw", new Object[0]));
        return false;
    }
}

