/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.storge;

import io.github.p2vman.eptalist.storge.Storge;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public interface Data<T>
extends Closeable {
    public boolean addUser(T var1);

    public boolean removeUser(T var1);

    public boolean is(T var1);

    public List<T> toList();

    public boolean addUser(T var1, Consumer<String> var2);

    public boolean removeUser(T var1, Consumer<String> var2);

    public boolean is(T var1, Consumer<String> var2);

    default public boolean dirty() {
        return false;
    }

    default public CompletionStage<Boolean> addUserAsync(T name, Consumer<String> callback) {
        return CompletableFuture.supplyAsync(() -> {
            Data data = this;
            synchronized (data) {
                return this.addUser(name, callback);
            }
        }, Storge.threadPool);
    }

    default public CompletableFuture<Boolean> removeUserAsync(T name, Consumer<String> callback) {
        return CompletableFuture.supplyAsync(() -> {
            Data data = this;
            synchronized (data) {
                return this.removeUser(name, callback);
            }
        }, Storge.threadPool);
    }

    default public CompletableFuture<Boolean> isAsync(T name, Consumer<String> callback) {
        return CompletableFuture.supplyAsync(() -> {
            Data data = this;
            synchronized (data) {
                return this.is(name, callback);
            }
        }, Storge.threadPool);
    }
}

