/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.storge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.github.p2vman.Static;
import io.github.p2vman.eptalist.storge.Data;
import io.github.p2vman.lang.Lang;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Json
extends ArrayList<String>
implements Data<String> {
    public Map<String, Object> data;

    @Override
    public void close() throws IOException {
        this.save();
    }

    @Override
    public boolean addUser(String name) {
        if (this.is(name)) {
            return false;
        }
        return this.add(name);
    }

    @Override
    public boolean is(String name) {
        return this.contains(name);
    }

    @Override
    public boolean removeUser(String name) {
        if (!this.is(name)) {
            return false;
        }
        return this.remove(name);
    }

    public Json(Map<String, Object> data) {
        this.data = data;
        if (this.size() <= 0) {
            this.load();
        }
    }

    public void load() {
        this.clear();
        try {
            JsonArray array = (JsonArray)Static.GSON.fromJson((Reader)new InputStreamReader(new FileInputStream((String)this.data.get("file"))), JsonArray.class);
            Iterator iterator = array.iterator();
            while (iterator.hasNext()) {
                this.add(((JsonElement)iterator.next()).getAsString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.save();
        }
    }

    public void save() {
        try {
            FileOutputStream stream = new FileOutputStream((String)this.data.get("file"));
            ((OutputStream)stream).write(Static.GSON.toJson((Object)this).getBytes(StandardCharsets.UTF_8));
            stream.flush();
            ((OutputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean add(String s) {
        if (super.add(s)) {
            this.save();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.save();
            return true;
        }
        return false;
    }

    @Override
    public void sort(Comparator<? super String> c) {
        super.sort(c);
        this.save();
    }

    @Override
    public List<String> toList() {
        return this;
    }

    @Override
    public boolean is(String name, Consumer<String> info) {
        return this.contains(name);
    }

    @Override
    public boolean removeUser(String name, Consumer<String> info) {
        if (!this.is(name)) {
            info.accept(Lang.LANG.format("storge.remove.not.in", name));
            return false;
        }
        return this.remove(name);
    }

    @Override
    public boolean addUser(String name, Consumer<String> info) {
        if (this.is(name)) {
            info.accept(Lang.LANG.format("storge.add.is.already", name));
            return false;
        }
        return this.add(name);
    }
}

