/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.storge;

import io.github.p2vman.eptalist.storge.Data;
import io.github.p2vman.lang.Lang;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Mysql
implements Data<String> {
    public Connection connection;
    public Map<String, Object> data;
    public String teable;
    public String i;

    public Mysql(Map<String, Object> data) {
        this.data = data;
        String teable_profix = data.containsKey("prefix") ? "eptalist" : (String)data.get("prefix");
        this.teable = data.containsKey("teable") ? teable_profix + "_users" : teable_profix + data.get("teable");
        this.i = data.containsKey("t") ? "username" : (String)data.get("t");
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            this.connection = DriverManager.getConnection((String)this.data.get("file"));
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + this.teable + " (" + this.i + " VARCHAR(255) PRIMARY KEY)");
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean removeUser(String name) {
        if (!this.is(name)) {
            return false;
        }
        try {
            PreparedStatement statement = this.connection.prepareStatement("DELETE FROM " + this.teable + " WHERE " + this.i + " = ?");
            statement.setString(1, name);
            return statement.executeUpdate() > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeUser(String name, Consumer<String> info) {
        if (!this.is(name)) {
            info.accept(Lang.LANG.format("storge.remove.not.in", name));
            return false;
        }
        try {
            PreparedStatement statement = this.connection.prepareStatement("DELETE FROM " + this.teable + " WHERE " + this.i + " = ?");
            statement.setString(1, name);
            return statement.executeUpdate() > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            info.accept(Lang.LANG.format("err.db", new Object[0]));
            return false;
        }
    }

    @Override
    public boolean is(String name, Consumer<String> info) {
        try {
            if (this.connection.isClosed()) {
                this.connection = DriverManager.getConnection(String.format((String)this.data.get("file"), new Object[0]));
                info.accept(Lang.LANG.format("storge.reconnect", new Object[0]));
            }
            PreparedStatement statement = this.connection.prepareStatement("SELECT user_name FROM " + this.teable + " WHERE " + this.i + " = ?");
            statement.setString(1, name);
            ResultSet resultSet = statement.executeQuery();
            return resultSet.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            info.accept(Lang.LANG.format("err.db", new Object[0]));
            return false;
        }
    }

    @Override
    public boolean is(String name) {
        try {
            if (this.connection.isClosed()) {
                this.connection = DriverManager.getConnection((String)this.data.get("file"));
            }
            PreparedStatement statement = this.connection.prepareStatement("SELECT username FROM " + this.teable + " WHERE " + this.i + " = ?");
            statement.setString(1, name);
            ResultSet resultSet = statement.executeQuery();
            return resultSet.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean addUser(String name, Consumer<String> info) {
        if (this.is(name)) {
            info.accept(Lang.LANG.format("storge.add.is.already", name));
            return false;
        }
        try {
            PreparedStatement statement = this.connection.prepareStatement("INSERT INTO " + this.teable + " (" + this.i + ") VALUES (?)");
            statement.setString(1, name);
            return statement.executeUpdate() > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            info.accept(Lang.LANG.format("err.db", new Object[0]));
            return false;
        }
    }

    @Override
    public boolean addUser(String name) {
        if (this.is(name)) {
            return false;
        }
        try {
            PreparedStatement statement = this.connection.prepareStatement("INSERT INTO " + this.teable + " (" + this.i + ") VALUES (?)");
            statement.setString(1, name);
            return statement.executeUpdate() > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> toList() {
        ArrayList<String> players = new ArrayList<String>();
        try {
            if (this.connection.isClosed()) {
                this.connection = DriverManager.getConnection((String)this.data.get("file"));
            }
            String sql = "SELECT " + this.i + " FROM " + this.teable;
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                players.add(rs.getString(this.i));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return players;
    }
}

