/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.storge;

import io.github.p2vman.eptalist.storge.Data;
import io.github.p2vman.lang.Lang;
import io.github.p2vman.nbt.NbtIo;
import io.github.p2vman.nbt.tag.Tag;
import io.github.p2vman.nbt.tag.TagCompound;
import io.github.p2vman.nbt.tag.TagList;
import io.github.p2vman.nbt.tag.TagString;
import io.github.p2vman.utils.Pair;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NBT
extends ArrayList<String>
implements Data<String> {
    private final NbtIo io = new NbtIo();
    public Map<String, Object> data;

    @Override
    public void close() throws IOException {
        this.save();
    }

    @Override
    public boolean addUser(String name) {
        if (this.is(name)) {
            return false;
        }
        return this.add(name);
    }

    @Override
    public boolean is(String name) {
        return this.contains(name);
    }

    @Override
    public boolean removeUser(String name) {
        if (!this.is(name)) {
            return false;
        }
        return this.remove(name);
    }

    public NBT(Map<String, Object> data) {
        this.data = data;
        if (this.size() <= 0) {
            this.load();
        }
    }

    public void load() {
        this.clear();
        try {
            InputStream stream = new FileInputStream((String)this.data.get("file"));
            if (this.data.containsKey("gzip") && ((Boolean)this.data.get("gzip")).booleanValue()) {
                stream = new GZIPInputStream(stream);
            }
            DataInputStream datastream = new DataInputStream(stream);
            Pair<String, Tag> tagr = this.io.read(datastream);
            if (tagr.v instanceof TagCompound) {
                TagCompound compound = (TagCompound)tagr.v;
                if (compound.is("whitelist") && compound.get("whitelist") instanceof TagList) {
                    TagList list = (TagList)compound.get("whitelist");
                    for (Tag tag : list) {
                        if (!(tag instanceof TagString)) continue;
                        this.add(((TagString)tag).getValue());
                    }
                }
            } else {
                this.save();
            }
            datastream.close();
        }
        catch (Exception e) {
            this.save();
        }
    }

    public void save() {
        try {
            OutputStream stream = new FileOutputStream((String)this.data.get("file"));
            if (this.data.containsKey("gzip") && ((Boolean)this.data.get("gzip")).booleanValue()) {
                stream = new GZIPOutputStream(stream);
            }
            DataOutputStream datastream = new DataOutputStream(stream);
            TagCompound compound = new TagCompound();
            TagList list = new TagList('\b');
            for (String s : this) {
                list.add(new TagString(s));
            }
            compound.put("whitelist", list);
            this.io.write(datastream, compound);
            datastream.close();
        }
        catch (Exception e) {
            this.save();
        }
    }

    @Override
    public boolean add(String s) {
        if (super.add(s)) {
            this.save();
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.save();
            return true;
        }
        return false;
    }

    @Override
    public void sort(Comparator<? super String> c) {
        super.sort(c);
        this.save();
    }

    @Override
    public List<String> toList() {
        return this;
    }

    @Override
    public boolean is(String name, Consumer<String> info) {
        return this.contains(name);
    }

    @Override
    public boolean removeUser(String name, Consumer<String> info) {
        if (!this.is(name)) {
            info.accept(Lang.LANG.format("storge.remove.not.in", name));
            return false;
        }
        return this.remove(name);
    }

    @Override
    public boolean addUser(String name, Consumer<String> info) {
        if (this.is(name)) {
            info.accept(Lang.LANG.format("storge.add.is.already", name));
            return false;
        }
        return this.add(name);
    }
}

