/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.storge;

import io.github.p2vman.eptalist.storge.Data;
import io.github.p2vman.eptalist.storge.Json;
import io.github.p2vman.eptalist.storge.Mysql;
import io.github.p2vman.eptalist.storge.NBT;
import io.github.p2vman.eptalist.storge.Sqlite;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public abstract class Storge<T>
implements Closeable {
    public static ExecutorService threadPool = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.defaultFactory.newThread(r);
            t.setName("data-async-pool-" + this.count++);
            t.setDaemon(true);
            return t;
        }
    });
    public static final Map<String, Class<? extends Data<String>>> sm = new HashMap<String, Class<? extends Data<String>>>();

    public static Class<? extends Data<String>> find(String clz) throws ClassNotFoundException, ClassCastException {
        Class<Object> cls = null;
        if (sm.containsKey(clz)) {
            cls = sm.get(clz);
        } else {
            try {
                cls = Class.forName(clz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cls == null) {
            throw new ClassNotFoundException();
        }
        if (!Data.class.isAssignableFrom(cls)) {
            throw new ClassCastException();
        }
        return cls;
    }

    public boolean dirty() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    static {
        sm.put("NBT", NBT.class);
        sm.put("nbt", NBT.class);
        sm.put("JSON", Json.class);
        sm.put("json", Json.class);
        sm.put("Sqlite", Sqlite.class);
        sm.put("SQLITE", Sqlite.class);
        sm.put("mysql", Mysql.class);
        sm.put("MYSQL", Mysql.class);
        sm.put("org.eptalist.storge.Json", Json.class);
        sm.put("org.eptalist.storge.NBT", NBT.class);
        sm.put("org.eptalist.storge.Sqlite", Sqlite.class);
        sm.put("org.eptalist.storge.Mysql", Mysql.class);
    }
}

