/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.eptalist.velocity;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import io.github.p2vman.Identifier;
import io.github.p2vman.eptalist.velocity.Velocity;
import io.github.p2vman.lang.Lang;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;

public class WhiteListCommand
implements SimpleCommand {
    private final String[] w1 = new String[]{"off", "on", "add", "remove", "list", "help", "mode", "reload"};
    private Logger logger;

    public WhiteListCommand(Logger logger) {
        this.logger = logger;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            sender.sendMessage((Component)Component.text((String)String.format("/eptalist (%s)", String.join((CharSequence)"/", this.w1))));
            return;
        }
        switch (args[0].toLowerCase()) {
            case "off": {
                Velocity.config.get().enable = false;
                Velocity.config.save();
                sender.sendMessage((Component)Component.text((String)Lang.LANG.format("command.off", new Object[0])));
                break;
            }
            case "on": {
                Velocity.config.get().enable = true;
                Velocity.config.save();
                sender.sendMessage((Component)Component.text((String)Lang.LANG.format("command.on", new Object[0])));
                break;
            }
            case "add": {
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Usage: /eptalist add <username>"));
                    break;
                }
                String usernameToAdd = args[1];
                if (!Velocity.list.addUser(usernameToAdd, t -> sender.sendMessage((Component)Component.text((String)t)))) break;
                sender.sendMessage((Component)Component.text((String)Lang.LANG.format("command.add.succes", usernameToAdd)));
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Usage: /eptalist remove <username>"));
                    break;
                }
                String usernameToRemove = args[1];
                if (!Velocity.list.removeUser(usernameToRemove, t -> sender.sendMessage((Component)Component.text((String)t)))) break;
                sender.sendMessage((Component)Component.text((String)Lang.LANG.format("command.remove.succes", usernameToRemove)));
                break;
            }
            case "list": {
                sender.sendMessage((Component)Component.text((String)("Whitelisted players: " + String.valueOf(Velocity.list.toList()))));
                break;
            }
            case "mode": {
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Usage: /eptalist mode <ID>"));
                    break;
                }
                Identifier id = Identifier.tryParse(args[1]);
                if (id != null && Velocity.identifiers.contains(id)) {
                    Velocity.config.get().curent = id;
                    Velocity.config.save();
                    Velocity.load();
                    sender.sendMessage((Component)Component.text((String)Lang.LANG.format("command.mode.succes", id)));
                    break;
                }
                sender.sendMessage((Component)Component.text((String)Lang.LANG.format("command.mode.invalid.id", new Object[0])));
                break;
            }
            case "help": {
                sender.sendMessage((Component)Component.text((String)String.join((CharSequence)"\n", "1: /eptalist add <username> - Add user to whitelist", "2: /eptalist remove <username> - Remove user from whitelist", "3: /eptalist list - Display whitelisted players", "4: /eptalist on - Enable whitelist", "5: /eptalist off - Disable whitelist", "6: /eptalist mode <ID> - Set list data mode", "7: /eptalist kick_nolisted - Kick non-whitelisted players", "8: /eptalist reload - Reload the whitelist configuration")));
                break;
            }
            case "reload": {
                try {
                    Velocity.load();
                    sender.sendMessage((Component)Component.text((String)Lang.LANG.format("command.reload.succes", new Object[0])));
                }
                catch (Exception e) {
                    this.logger.error("Failed to reload the configuration.", (Throwable)e);
                    sender.sendMessage((Component)Component.text((String)Lang.LANG.format("command.reload.failed", new Object[0])));
                }
                break;
            }
            default: {
                sender.sendMessage((Component)Component.text((String)Lang.LANG.getOrDefult("command.default")));
            }
        }
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            return ImmutableList.of();
        }
        if (args.length == 1) {
            return Arrays.stream(this.w1).filter(cmd -> cmd.startsWith(args[0].toLowerCase())).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }
}

