/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.lang;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.p2vman.Static;
import io.github.p2vman.lang.Formatter;
import io.github.p2vman.lang.Lang;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class Language
implements Lang,
BiConsumer<String, String>,
Consumer<InputStream>,
BiFunction<JsonElement, Stack<String>, Void> {
    private Formatter formatter = String::format;
    private Map<String, String> map = new HashMap<String, String>();
    private static final Pattern UNSUPPORTED_FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");

    @Override
    public String get(String id) {
        return this.map.get(id);
    }

    @Override
    public String getOrDefult(String id) {
        return this.map.getOrDefault(id, id);
    }

    @Override
    public String getOrDefult(String id, String defult) {
        return this.map.getOrDefault(id, defult);
    }

    @Override
    public void accept(String s, String s2) {
        this.map.put(s, s2);
    }

    @Override
    public boolean has(String id) {
        return this.map.containsKey(id);
    }

    @Override
    public void accept(InputStream stream) {
        JsonObject jsonObject = (JsonObject)Static.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry entry : jsonObject.entrySet()) {
            Stack<String> stack = new Stack<String>();
            stack.push((String)entry.getKey());
            this.apply((JsonElement)entry.getValue(), stack);
        }
    }

    @Override
    public Void apply(JsonElement jsonElement, Stack<String> strings) {
        if (jsonElement.isJsonObject()) {
            for (Map.Entry entry : jsonElement.getAsJsonObject().entrySet()) {
                Stack<String> strings2 = new Stack<String>();
                strings2.addAll(strings);
                strings2.push((String)entry.getKey());
                this.apply((JsonElement)entry.getValue(), strings2);
            }
        } else {
            this.accept(String.join((CharSequence)".", strings), UNSUPPORTED_FORMAT_PATTERN.matcher(jsonElement.getAsString()).replaceAll("%$1s"));
        }
        return null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public String format(String id, Object ... args) {
        return this.formatter.format(this.getOrDefult(id), args);
    }

    @Override
    public Formatter setFormater(Formatter formatter) {
        this.formatter = formatter;
        return formatter;
    }

    public String toString() {
        return "Language(formatter=" + this.formatter + ", map=" + this.map + ")";
    }
}

