/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt;

import io.github.p2vman.nbt.TagReader;
import io.github.p2vman.nbt.TagWriter;
import io.github.p2vman.nbt.tag.Tag;
import io.github.p2vman.nbt.tag.TagByte;
import io.github.p2vman.nbt.tag.TagByteArray;
import io.github.p2vman.nbt.tag.TagCompound;
import io.github.p2vman.nbt.tag.TagDouble;
import io.github.p2vman.nbt.tag.TagEnd;
import io.github.p2vman.nbt.tag.TagFloat;
import io.github.p2vman.nbt.tag.TagInt;
import io.github.p2vman.nbt.tag.TagIntArray;
import io.github.p2vman.nbt.tag.TagList;
import io.github.p2vman.nbt.tag.TagLong;
import io.github.p2vman.nbt.tag.TagLongArray;
import io.github.p2vman.nbt.tag.TagShort;
import io.github.p2vman.nbt.tag.TagString;
import io.github.p2vman.utils.Pair;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NbtIo {
    private final Map<Character, Class<? extends Tag>> idclass;

    public NbtIo(Map<Character, Class<? extends Tag>> idclass) {
        this.idclass = idclass;
    }

    public NbtIo() {
        this.idclass = new HashMap<Character, Class<? extends Tag>>();
        for (Tag tag : new Tag[]{new TagEnd(), new TagFloat(), new TagInt(), new TagCompound(), new TagIntArray(), new TagList(), new TagByte(), new TagByteArray(), new TagDouble(), new TagLong(), new TagLongArray(), new TagShort(), new TagString()}) {
            this.idclass.put(Character.valueOf(tag.getID()), tag.getClass());
        }
    }

    public Pair<String, Tag> read(DataInputStream stream) throws IOException {
        TagReader reader = new TagReader(this.idclass);
        return reader.read(stream);
    }

    public void write(DataOutputStream stream, Tag tag) throws IOException {
        TagWriter writer = new TagWriter(this.idclass);
        writer.write(stream, tag);
    }

    public TagCompound readCompound(DataInputStream stream) throws IOException {
        TagReader reader = new TagReader(this.idclass);
        Tag tag = (Tag)reader.read((DataInputStream)stream).v;
        return tag instanceof TagCompound ? (TagCompound)tag : new TagCompound();
    }

    public static NbtIo create(Tag ... tags) {
        return new NbtIo();
    }
}

