/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt;

import io.github.p2vman.nbt.tag.Tag;
import io.github.p2vman.nbt.tag.TagEnd;
import io.github.p2vman.utils.Pair;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class TagReader {
    public final Map<Character, Class<? extends Tag>> idclass;

    public TagReader(Map<Character, Class<? extends Tag>> idclass) {
        this.idclass = idclass;
    }

    public Pair<String, Tag> read(DataInputStream stream) throws IOException {
        char type = (char)stream.readByte();
        if (type == '\u0000') {
            return new Pair<String, Tag>("", new TagEnd());
        }
        for (Map.Entry<Character, Class<? extends Tag>> entry : this.idclass.entrySet()) {
            if (entry.getKey().charValue() != type) continue;
            try {
                Pair<String, Tag> pair = new Pair<String, Tag>(stream.readUTF(), entry.getValue().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                ((Tag)pair.v).read(stream, this);
                return pair;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        return new Pair<String, Tag>("", new TagEnd());
    }
}

