/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt.tag;

import io.github.p2vman.nbt.TagReader;
import io.github.p2vman.nbt.TagWriter;
import io.github.p2vman.nbt.tag.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class TagByteArray
extends Tag {
    private byte[] value;

    public int size() {
        if (this.value != null) {
            return this.value.length;
        }
        return 0;
    }

    public TagByteArray(byte[] value) {
        this.value = value;
    }

    @Override
    public char getID() {
        return '\u0007';
    }

    @Override
    public void read(DataInputStream stream, TagReader reader) throws IOException {
        byte[] buffer = new byte[4];
        stream.read(buffer);
        this.value = new byte[ByteBuffer.wrap(buffer).getInt()];
        stream.read(this.value);
    }

    @Override
    public void write(DataOutputStream stream, TagWriter writer) throws IOException {
        stream.write(ByteBuffer.allocate(4).putInt(this.value.length).array());
        stream.write(this.value);
    }

    public TagByteArray() {
    }

    public String toString() {
        return "TagByteArray(value=" + Arrays.toString(this.getValue()) + ")";
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }
}

