/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt.tag;

import io.github.p2vman.nbt.TagReader;
import io.github.p2vman.nbt.TagWriter;
import io.github.p2vman.nbt.tag.Tag;
import io.github.p2vman.utils.Pair;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TagCompound
extends Tag {
    private Map<String, Tag> tagMap = new HashMap<String, Tag>();

    public void put(String name, Tag tag) {
        this.tagMap.put(name, tag);
    }

    public Tag get(String name) {
        return this.tagMap.get(name);
    }

    public boolean is(String name) {
        return this.tagMap.containsKey(name);
    }

    @Override
    public void write(DataOutputStream stream, TagWriter writer) throws IOException {
        for (Map.Entry<String, Tag> entry : this.tagMap.entrySet()) {
            writer.write(stream, entry.getValue(), entry.getKey());
        }
        stream.writeByte(0);
    }

    @Override
    public char getID() {
        return '\n';
    }

    @Override
    public void read(DataInputStream stream, TagReader reader) throws IOException {
        Pair<String, Tag> tagPair;
        this.tagMap.clear();
        while ((tagPair = reader.read(stream)).getV().getID() != '\u0000') {
            this.tagMap.put((String)tagPair.k, (Tag)tagPair.v);
        }
    }

    public String toString() {
        return "TagCompound(tagMap=" + this.tagMap + ")";
    }
}

