/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt.tag;

import io.github.p2vman.nbt.TagReader;
import io.github.p2vman.nbt.TagWriter;
import io.github.p2vman.nbt.tag.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TagDouble
extends Tag {
    private double value;

    public TagDouble(double value) {
        this.value = value;
    }

    @Override
    public char getID() {
        return '\u0006';
    }

    @Override
    public void read(DataInputStream stream, TagReader reader) throws IOException {
        byte[] buffer = new byte[8];
        stream.read(buffer);
        this.value = ByteBuffer.wrap(buffer).getDouble();
    }

    @Override
    public void write(DataOutputStream stream, TagWriter writer) throws IOException {
        stream.write(ByteBuffer.allocate(8).putDouble(this.value).array());
    }

    public TagDouble() {
    }

    public String toString() {
        return "TagDouble(value=" + this.getValue() + ")";
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }
}

