/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt.tag;

import io.github.p2vman.nbt.TagReader;
import io.github.p2vman.nbt.TagWriter;
import io.github.p2vman.nbt.tag.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TagFloat
extends Tag {
    private float value;

    public TagFloat(float value) {
        this.value = value;
    }

    @Override
    public char getID() {
        return '\u0005';
    }

    @Override
    public void read(DataInputStream stream, TagReader reader) throws IOException {
        byte[] buffer = new byte[4];
        stream.read(buffer);
        this.value = ByteBuffer.wrap(buffer).getFloat();
    }

    @Override
    public void write(DataOutputStream stream, TagWriter writer) throws IOException {
        stream.write(ByteBuffer.allocate(4).putFloat(this.value).array());
    }

    public TagFloat() {
    }

    public String toString() {
        return "TagFloat(value=" + this.getValue() + ")";
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }
}

