/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt.tag;

import io.github.p2vman.nbt.TagReader;
import io.github.p2vman.nbt.TagWriter;
import io.github.p2vman.nbt.tag.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TagInt
extends Tag {
    private int value;

    public TagInt(int value) {
        this.value = value;
    }

    @Override
    public char getID() {
        return '\u0003';
    }

    @Override
    public void read(DataInputStream stream, TagReader reader) throws IOException {
        byte[] buffer = new byte[4];
        stream.read(buffer);
        this.value = ByteBuffer.wrap(buffer).getInt();
    }

    @Override
    public void write(DataOutputStream stream, TagWriter writer) throws IOException {
        stream.write(ByteBuffer.allocate(4).putInt(this.value).array());
    }

    public TagInt() {
    }

    public String toString() {
        return "TagInt(value=" + this.getValue() + ")";
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}

