/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt.tag;

import io.github.p2vman.nbt.TagReader;
import io.github.p2vman.nbt.TagWriter;
import io.github.p2vman.nbt.tag.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class TagIntArray
extends Tag {
    private int[] value;

    public int size() {
        if (this.value != null) {
            return this.value.length;
        }
        return 0;
    }

    public TagIntArray(int[] value) {
        this.value = value;
    }

    @Override
    public char getID() {
        return '\u000b';
    }

    @Override
    public void read(DataInputStream stream, TagReader reader) throws IOException {
        byte[] buffer = new byte[4];
        stream.read(buffer);
        this.value = new int[ByteBuffer.wrap(buffer).getInt()];
        for (int i = 0; i < this.value.length; ++i) {
            stream.read(buffer);
            this.value[i] = ByteBuffer.wrap(buffer).getInt();
        }
    }

    @Override
    public void write(DataOutputStream stream, TagWriter writer) throws IOException {
        stream.write(ByteBuffer.allocate(4).putInt(this.value.length).array());
        for (int i = 0; i < this.value.length; ++i) {
            stream.write(ByteBuffer.allocate(4).putInt(this.value[i]).array());
        }
    }

    public TagIntArray() {
    }

    public String toString() {
        return "TagIntArray(value=" + Arrays.toString(this.getValue()) + ")";
    }

    public int[] getValue() {
        return this.value;
    }

    public void setValue(int[] value) {
        this.value = value;
    }
}

