/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt.tag;

import io.github.p2vman.nbt.TagReader;
import io.github.p2vman.nbt.TagWriter;
import io.github.p2vman.nbt.tag.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TagList
extends Tag
implements Iterable<Tag> {
    private char type;
    private List<Tag> values = new ArrayList<Tag>(0);

    public int size() {
        return this.values.size();
    }

    public boolean add(Tag tag) {
        return this.values.add(tag);
    }

    public Tag remove(int index) {
        return this.values.remove(index);
    }

    public boolean remove(Tag tag) {
        return this.values.remove(tag);
    }

    public TagList(char type) {
        this.type = type;
    }

    @Override
    public void write(DataOutputStream stream, TagWriter writer) throws IOException {
        stream.writeByte(this.type);
        stream.writeInt(this.values.size());
        for (Tag tag : this.values) {
            tag.write(stream, writer);
        }
    }

    @Override
    public char getID() {
        return '\t';
    }

    @Override
    public void read(DataInputStream stream, TagReader reader) throws IOException {
        this.values.clear();
        this.type = (char)stream.readByte();
        int s = stream.readInt();
        Class<? extends Tag> cls = reader.idclass.get(Character.valueOf(this.type));
        for (int i = 0; i < s; ++i) {
            try {
                Tag tag = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                tag.read(stream, reader);
                this.values.add(tag);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.values.iterator();
    }

    public TagList() {
    }

    public String toString() {
        return "TagList(type=" + this.getType() + ", values=" + this.values + ")";
    }

    public char getType() {
        return this.type;
    }
}

