/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.nbt.tag;

import io.github.p2vman.nbt.TagReader;
import io.github.p2vman.nbt.TagWriter;
import io.github.p2vman.nbt.tag.Tag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class TagLongArray
extends Tag {
    private long[] value;

    public int size() {
        if (this.value != null) {
            return this.value.length;
        }
        return 0;
    }

    public TagLongArray(long[] value) {
        this.value = value;
    }

    @Override
    public char getID() {
        return '\f';
    }

    @Override
    public void read(DataInputStream stream, TagReader reader) throws IOException {
        this.value = new long[stream.readInt()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = stream.readLong();
        }
    }

    @Override
    public void write(DataOutputStream stream, TagWriter writer) throws IOException {
        stream.writeInt(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            stream.writeLong(this.value[i]);
        }
    }

    public TagLongArray() {
    }

    public String toString() {
        return "TagLongArray(value=" + Arrays.toString(this.getValue()) + ")";
    }

    public long[] getValue() {
        return this.value;
    }

    public void setValue(long[] value) {
        this.value = value;
    }
}

