/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.profiling;

import io.github.p2vman.profiling.Profiler;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ExempleProfiler
implements Profiler {
    private final Map<String, Long> totalTimes = new HashMap<String, Long>();
    private final Stack<String> stack = new Stack();
    private final Map<String, Long> startTimes = new HashMap<String, Long>();

    @Override
    public void push(String name) {
        this.stack.push(name);
        this.startTimes.put(name, System.nanoTime());
    }

    @Override
    public String pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException();
        }
        String name = this.stack.pop();
        Long startTime = this.startTimes.remove(name);
        if (startTime == null) {
            throw new IllegalStateException(name);
        }
        long elapsedTime = System.nanoTime() - startTime;
        this.totalTimes.put(name, this.totalTimes.getOrDefault(name, 0L) + elapsedTime);
        return name;
    }

    @Override
    public String peek() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException();
        }
        return this.stack.peek();
    }

    @Override
    public long getElapsedTimeAndRemove(String name) {
        Long elapsedTime = this.totalTimes.remove(name);
        if (elapsedTime == null) {
            throw new IllegalStateException(name);
        }
        return elapsedTime / 1000000L;
    }

    @Override
    public long getElapsedTime(String name) {
        Long elapsedTime = this.totalTimes.get(name);
        if (elapsedTime == null) {
            throw new IllegalStateException(name);
        }
        return elapsedTime / 1000000L;
    }
}

