/*
 * Decompiled with CFR 0.152.
 */
package io.github.p2vman.updater;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;

public class Updater {
    private static Updater updater;
    private String id;
    private static final String API_URL = "https://api.spiget.org/v2/resources/";
    private static final String URL = "https://www.spigotmc.org/";
    private JsonObject object;

    public static Updater getInstance() {
        if (updater == null) {
            updater = new Updater();
        }
        return updater;
    }

    public JsonObject getJson() {
        return this.object.deepCopy();
    }

    public Updater() {
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(Updater.class.getClassLoader().getResourceAsStream("updater.json")));){
            JsonObject jsonObject;
            this.object = jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            this.id = jsonObject.get("id").getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JsonObject getLasted() throws IOException {
        URL url = new URL(API_URL + this.id + "/versions/latest");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        return JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(conn.getInputStream()))).getAsJsonObject();
    }

    public String getVersionUrl() throws IOException {
        URL url = new URL(API_URL + this.id);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        return URL + JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(conn.getInputStream()))).getAsJsonObject().get("file").getAsJsonObject().get("url").getAsString();
    }

    public String getId() {
        return this.id;
    }
}

