/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife;

import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BiomeModificationsContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.LoadCompleteCallback;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import fuzs.sealife.config.CommonConfig;
import fuzs.sealife.init.ModEntityTypes;
import fuzs.sealife.init.ModLootTables;
import fuzs.sealife.init.ModRegistry;
import fuzs.sealife.world.level.block.HatcheryBlock;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5483;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaLife
implements ModConstructor {
    public static final String MOD_ID = "sealife";
    public static final String MOD_NAME = "Sea Life";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Sea Life");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"sealife").common(CommonConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        SeaLife.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        LoadCompleteCallback.EVENT.register(HatcheryBlock::onLoadComplete);
        LootTableLoadCallback.EVENT.register(ModLootTables::onLootTableLoad);
    }

    public void onRegisterEntityAttributes(EntityAttributesContext context) {
        ModEntityTypes.onRegisterEntityAttributes(context);
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        ModEntityTypes.onRegisterSpawnPlacements(context);
    }

    public void onRegisterBiomeModifications(BiomeModificationsContext context) {
        SeaLife.addFishSpawn(context, ModEntityTypes.ANCHOVY, ModRegistry.SPAWNS_ANCHOVY_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).anchovy);
        SeaLife.addFishSpawn(context, ModEntityTypes.ANGELFISH, ModRegistry.SPAWNS_ANGELFISH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).angelfish);
        SeaLife.addFishSpawn(context, ModEntityTypes.ANGLERFISH, ModRegistry.SPAWNS_ANGLERFISH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).anglerfish);
        SeaLife.addFishSpawn(context, ModEntityTypes.BASS, ModRegistry.SPAWNS_BASS_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).bass);
        SeaLife.addFishSpawn(context, ModEntityTypes.BLUE_TANG, ModRegistry.SPAWNS_BLUE_TANG_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).blueTang);
        SeaLife.addFishSpawn(context, ModEntityTypes.BOWFIN, ModRegistry.SPAWNS_BOWFIN_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).bowfin);
        SeaLife.addFishSpawn(context, ModEntityTypes.BUTTERFLYFISH, ModRegistry.SPAWNS_BUTTERFLYFISH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).butterflyfish);
        SeaLife.addFishSpawn(context, ModEntityTypes.CARP, ModRegistry.SPAWNS_CARP_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).carp);
        SeaLife.addFishSpawn(context, ModEntityTypes.CATFISH, ModRegistry.SPAWNS_CATFISH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).catfish);
        SeaLife.addFishSpawn(context, ModEntityTypes.CHUB, ModRegistry.SPAWNS_CHUB_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).chub);
        SeaLife.addFishSpawn(context, ModEntityTypes.DAMSELFISH, ModRegistry.SPAWNS_DAMSELFISH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).damselfish);
        SeaLife.addFishSpawn(context, ModEntityTypes.ELECTRIC_RAY, ModRegistry.SPAWNS_ELECTRIC_RAY_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).electricRay);
        SeaLife.addFishSpawn(context, ModEntityTypes.GOLDFISH, ModRegistry.SPAWNS_GOLDFISH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).goldfish);
        SeaLife.addFishSpawn(context, ModEntityTypes.KOI, ModRegistry.SPAWNS_KOI_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).koi);
        SeaLife.addFishSpawn(context, ModEntityTypes.LAMPREY, ModRegistry.SPAWNS_LAMPREY_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).lamprey);
        SeaLife.addFishSpawn(context, ModEntityTypes.LUNGFISH, ModRegistry.SPAWNS_LUNGFISH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).lungfish);
        SeaLife.addFishSpawn(context, ModEntityTypes.MANTA_RAY, ModRegistry.SPAWNS_MANTA_RAY_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).mantaRay);
        SeaLife.addFishSpawn(context, ModEntityTypes.MINNOW, ModRegistry.SPAWNS_MINNOW_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).minnow);
        SeaLife.addFishSpawn(context, ModEntityTypes.NEON_TETRA, ModRegistry.SPAWNS_NEON_TETRA_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).neonTetra);
        SeaLife.addFishSpawn(context, ModEntityTypes.NORTHERN_PIKE, ModRegistry.SPAWNS_NORTHERN_PIKE_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).northernPike);
        SeaLife.addFishSpawn(context, ModEntityTypes.PERCH, ModRegistry.SPAWNS_PERCH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).perch);
        SeaLife.addFishSpawn(context, ModEntityTypes.PICKEREL, ModRegistry.SPAWNS_PICKEREL_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).pickerel);
        SeaLife.addFishSpawn(context, ModEntityTypes.PIRANHA, ModRegistry.SPAWNS_PIRANHA_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).piranha);
        SeaLife.addFishSpawn(context, ModEntityTypes.PUPFISH, ModRegistry.SPAWNS_PUPFISH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).pupfish);
        SeaLife.addFishSpawn(context, ModEntityTypes.SARDINE, ModRegistry.SPAWNS_SARDINE_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).sardine);
        SeaLife.addFishSpawn(context, ModEntityTypes.SIAMESE_FIGHTING_FISH, ModRegistry.SPAWNS_SIAMESE_FIGHTING_FISH_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).siameseFightingFish);
        SeaLife.addFishSpawn(context, ModEntityTypes.WHITEMARGIN_STARGAZER, ModRegistry.SPAWNS_WHITEMARGIN_STARGAZER_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).whitemarginStargazer);
        SeaLife.addFishSpawn(context, ModEntityTypes.STINGRAY, ModRegistry.SPAWNS_STINGRAY_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).stingray);
        SeaLife.addFishSpawn(context, ModEntityTypes.SILVER_STRIPE_BLAASOP, ModRegistry.SPAWNS_SILVER_STRIPE_BLAASOP_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).silverStripeBlaasop);
        SeaLife.addFishSpawn(context, ModEntityTypes.TROUT, ModRegistry.SPAWNS_TROUT_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).trout);
        SeaLife.addFishSpawn(context, ModEntityTypes.TUNA, ModRegistry.SPAWNS_TUNA_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).tuna);
        SeaLife.addFishSpawn(context, ModEntityTypes.WALLEYE, ModRegistry.SPAWNS_WALLEYE_BIOME_TAG, () -> ((CommonConfig)SeaLife.CONFIG.get(CommonConfig.class)).walleye);
    }

    static void addFishSpawn(BiomeModificationsContext context, class_6880.class_6883<? extends class_1299<?>> holder, class_6862<class_1959> tagKey, Supplier<CommonConfig.FishSpawnConfig> configSupplier) {
        context.registerBiomeModification(BiomeLoadingPhase.ADDITIONS, biomeLoadingContext -> biomeLoadingContext.is(tagKey), biomeModificationContext -> {
            CommonConfig.FishSpawnConfig config = (CommonConfig.FishSpawnConfig)configSupplier.get();
            biomeModificationContext.mobSpawnSettings().addSpawn(((class_1299)holder.comp_349()).method_5891(), config.weight, new class_5483.class_1964((class_1299)holder.comp_349(), config.minCount, config.maxCount));
        });
    }

    public static class_2960 id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

