/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.level.block.entity;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class HatcheryRenderData {
    private FishData[] data = new FishData[0];
    @Nullable
    private class_1297 displayEntity;

    public void reload(class_1937 level, @Nullable class_1299<?> entityType, int count) {
        this.displayEntity = entityType != null ? entityType.method_5883(level, class_3730.field_52444) : null;
        FishData[] data = new FishData[entityType != null ? count : 0];
        for (int i = 0; i < data.length; ++i) {
            data[i] = i < this.data.length ? this.data[i] : new FishData(level.method_8409());
        }
        this.data = data;
    }

    public void tick() {
        if (this.displayEntity != null) {
            ++this.displayEntity.field_6012;
            for (FishData fishData : this.data) {
                fishData.tick();
            }
        }
    }

    @Nullable
    public class_1297 getDisplayEntity() {
        return this.displayEntity;
    }

    public int getCount() {
        return this.data.length;
    }

    public void clearDisplayEntity() {
        this.displayEntity = null;
    }

    public float getRotation(int index) {
        return this.data[index].getRotation();
    }

    public float getHeight(int index) {
        return this.data[index].getHeight();
    }

    public boolean isClockwise(int index) {
        return this.data[index].isClockwise();
    }

    public static final class FishData {
        private int rotation;
        private final boolean clockwise;
        private final int speed;
        private final float height;

        public FishData(class_5819 randomSource) {
            this(randomSource.method_43048(720000), randomSource.method_43056(), 1 + randomSource.method_43048(5), randomSource.method_43057() * 9.0f);
        }

        public FishData(int rotation, boolean clockwise, int speed, float height) {
            this.rotation = rotation;
            this.clockwise = clockwise;
            this.speed = speed;
            this.height = height;
        }

        public void tick() {
            this.rotation += this.speed * (this.clockwise ? -10 : 10);
        }

        public float getRotation() {
            return 720.0f * (float)(this.rotation & 0x3FFF) / 16383.0f;
        }

        public boolean isClockwise() {
            return this.clockwise;
        }

        public float getHeight() {
            return this.height;
        }
    }
}

