/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.level.block.entity;

import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.sealife.SeaLife;
import fuzs.sealife.init.ModBlocks;
import fuzs.sealife.world.level.block.entity.HatcheryRenderData;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5761;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class HatcheryBlockEntity
extends class_2586
implements TickingBlockEntity {
    static final String TAG_ENTITY = "Entity";
    static final String TAG_COUNT = "Count";
    private final HatcheryRenderData renderer = new HatcheryRenderData();
    @Nullable
    private class_1299<?> entityType;
    private int count;

    public HatcheryBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlocks.HATCHERY_BLOCK_ENTITY_TYPE.comp_349(), blockPos, blockState);
    }

    public void clientTick() {
        if (!this.isEmpty()) {
            this.getRenderData().tick();
        }
    }

    public boolean isEmpty() {
        return this.entityType == null || this.count == 0;
    }

    private void setFish(@Nullable class_1299<?> entityType, int count) {
        if (entityType == null || this.entityType == null || this.entityType == entityType) {
            this.entityType = entityType;
            this.count = count;
            if (this.method_11002()) {
                if (this.method_10997().method_8608()) {
                    this.renderer.reload(this.method_10997(), entityType, count);
                } else {
                    this.markUpdated();
                }
            } else {
                this.renderer.clearDisplayEntity();
            }
        } else {
            SeaLife.LOGGER.warn("Unable to update hatchery at {}", (Object)this.method_11016());
        }
    }

    public void addFish(@Nullable class_1299<?> entityType, int amount) {
        int count = entityType != null ? Math.clamp((long)(this.count + amount), 0, 12) : 0;
        this.setFish(count == 0 ? null : entityType, count);
    }

    public void removeFish(int count, boolean spawnEntity) {
        if (this.entityType != null) {
            count = Math.min(this.count, count);
            for (int i = 0; i < count; ++i) {
                class_1297 entity;
                if (spawnEntity && (entity = this.entityType.method_5894((class_3218)this.method_10997(), class_1799.field_8037, null, this.field_11867, class_3730.field_16473, true, false)) instanceof class_5761) {
                    class_5761 bucketable = (class_5761)entity;
                    bucketable.method_6454(true);
                }
                this.addFish(this.entityType, -1);
            }
        }
    }

    public HatcheryRenderData getRenderData() {
        return this.renderer;
    }

    @Nullable
    public class_1299<?> getEntityType() {
        return this.entityType;
    }

    public int getCount() {
        return this.count;
    }

    protected void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        class_1299 entityType = valueInput.method_71426(TAG_ENTITY, class_7923.field_41177.method_39673()).orElse(null);
        byte count = valueInput.method_71421(TAG_COUNT, (byte)0);
        this.setFish(entityType, count);
    }

    protected void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71477(TAG_ENTITY, class_7923.field_41177.method_39673(), this.entityType);
        valueOutput.method_71462(TAG_COUNT, (byte)this.count);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_58692(registries);
    }

    private void markUpdated() {
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        if (this.method_11002()) {
            this.removeFish(this.count, true);
        }
    }
}

