/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.sealife.init.ModBlocks;
import fuzs.sealife.init.ModLootTables;
import fuzs.sealife.init.ModRegistry;
import fuzs.sealife.world.level.block.entity.FishTrapBlockEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class FishTrapBlock
extends class_2237
implements class_3737,
TickingEntityBlock<FishTrapBlockEntity> {
    public static final MapCodec<FishTrapBlock> CODEC = FishTrapBlock.method_54094(FishTrapBlock::new);
    public static final List<class_2338> WATER_OFFSETS = class_2338.method_25998((class_2338)class_2338.field_10980, (int)1, (int)1, (int)1).filter(blockPos -> blockPos.method_19455((class_2382)class_2338.field_10980) == 1).map(class_2338::method_10062).toList();
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 STAGE = class_2741.field_12549;
    public static final class_2746 ENABLED = class_2741.field_12515;

    public FishTrapBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE)).method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)ENABLED, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        boolean bl = fluidState.method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(bl))).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(FishTrapBlock.isSurroundedByWater((class_4538)context.method_8045(), context.method_8037())));
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 scheduledTickAccess, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        return (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(FishTrapBlock.isSurroundedByWater(level, pos)));
    }

    public static boolean isSurroundedByWater(class_4538 level, class_2338 blockPos) {
        int waterOnSides = 0;
        for (class_2338 offsetPos : WATER_OFFSETS) {
            if (!level.method_8316(blockPos.method_10081((class_2382)offsetPos)).method_15767(class_3486.field_15517)) continue;
            ++waterOnSides;
        }
        return waterOnSides >= 5;
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected boolean method_9542(class_2680 state) {
        return super.method_9542(state) && (Boolean)state.method_11654((class_2769)WATERLOGGED) != false;
    }

    protected void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        FishTrapBlockEntity blockEntity;
        class_2586 class_25862;
        if (randomSource.method_43048(7) == 0 && ((Boolean)blockState.method_11654((class_2769)ENABLED)).booleanValue() && (class_25862 = serverLevel.method_8321(blockPos)) instanceof FishTrapBlockEntity && (blockEntity = (FishTrapBlockEntity)class_25862).isBaited()) {
            if ((Integer)blockState.method_11654((class_2769)STAGE) == 0) {
                serverLevel.method_8652(blockPos, (class_2680)blockState.method_28493((class_2769)STAGE), 2);
            } else {
                class_8567 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockPos)).method_51874(class_181.field_1229, (Object)blockEntity.method_5438(0)).method_51875(class_173.field_1176);
                class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(ModLootTables.FISH_TRAP);
                ObjectArrayList list = lootTable.method_51878(lootParams);
                class_1799 itemStack = list.isEmpty() ? class_1799.field_8037 : (class_1799)list.getFirst();
                blockEntity.method_5447(0, itemStack);
                serverLevel.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(0)), 2);
            }
        }
    }

    protected class_1269 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof FishTrapBlockEntity) {
            FishTrapBlockEntity blockEntity = (FishTrapBlockEntity)class_25862;
            if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() && blockEntity.method_5438(0).method_7960() && itemStack.method_31573(ModRegistry.FISHING_BAIT_ITEM_TAG)) {
                if (!level.method_8608()) {
                    player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
                    blockEntity.method_5447(0, itemStack.method_60504(1, (class_1309)player));
                    level.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 1.0f, 1.0f);
                }
                return class_1269.field_5812;
            }
            return super.method_55765(itemStack, state, level, pos, player, hand, hitResult);
        }
        return class_1269.field_5811;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof FishTrapBlockEntity) {
            FishTrapBlockEntity blockEntity = (FishTrapBlockEntity)class_25862;
            if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() && !blockEntity.method_5438(0).method_7960() && !blockEntity.isBaited()) {
                if (!level.method_8608()) {
                    class_1799 itemStack = blockEntity.method_5434(0, 1);
                    level.method_8396(null, pos, class_3417.field_14770, class_3419.field_15245, 1.0f, 1.0f);
                    if (!player.method_31548().method_7394(itemStack)) {
                        player.method_7328(itemStack, false);
                    }
                    level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                    if (level.method_8409().method_43048(3) == 0) {
                        level.method_22352(pos, false);
                    }
                }
                return class_1269.field_5812;
            }
            return super.method_55766(state, level, pos, player, hitResult);
        }
        return class_1269.field_5811;
    }

    public class_2591<? extends FishTrapBlockEntity> getBlockEntityType() {
        return (class_2591)ModBlocks.FISH_TRAP_BLOCK_ENTITY_TYPE.comp_349();
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2350 direction) {
        return class_1703.method_7608((class_2586)level.method_8321(blockPos));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, STAGE, ENABLED});
    }
}

