/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import fuzs.sealife.init.ModBlocks;
import fuzs.sealife.init.ModRegistry;
import fuzs.sealife.world.level.block.entity.HatcheryBlockEntity;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5328;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class HatcheryBlock
extends class_2237
implements class_3737,
TickingEntityBlock<HatcheryBlockEntity> {
    public static final int MAX_CAPACITY = 12;
    public static final int COMMON_CYCLES = 3;
    public static final int UNCOMMON_CYCLES = 5;
    public static final int RARE_CYCLES = 7;
    public static final MapCodec<HatcheryBlock> CODEC = HatcheryBlock.method_54094(HatcheryBlock::new);
    protected static final class_265 SHAPE_INSIDE = class_2248.method_66404((double)14.0, (double)1.0, (double)16.0);
    protected static final class_265 SHAPE = class_259.method_1072((class_265)class_2248.method_66404((double)16.0, (double)0.0, (double)15.0), (class_265)SHAPE_INSIDE, (class_247)class_247.field_16886);
    protected static final class_265 COLLISION_SHAPE = class_259.method_1072((class_265)class_259.method_1077(), (class_265)SHAPE_INSIDE, (class_247)class_247.field_16886);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 STAGE = class_2758.method_11867((String)"stage", (int)0, (int)Math.max(Math.max(3, 5), 7));
    static Map<class_1299<?>, class_1792> bucketableMobs = Collections.emptyMap();

    public HatcheryBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE)).method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public static void onLoadComplete() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (class_1792 item : class_7923.field_41178) {
            if (!(item instanceof class_1785)) continue;
            class_1785 mobBucketItem = (class_1785)item;
            builder.put((Object)mobBucketItem.field_7991, (Object)item);
        }
        bucketableMobs = builder.build();
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        boolean bl = fluidState.method_15772() == class_3612.field_15910;
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 scheduledTickAccess, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        return super.method_9559(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPE;
    }

    protected boolean method_9542(class_2680 state) {
        return super.method_9542(state) && (Boolean)state.method_11654((class_2769)WATERLOGGED) != false;
    }

    protected void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        HatcheryBlockEntity blockEntity;
        class_2586 class_25862;
        if (randomSource.method_43048(3) == 0 && (class_25862 = serverLevel.method_8321(blockPos)) instanceof HatcheryBlockEntity && (blockEntity = (HatcheryBlockEntity)class_25862).getEntityType() != null && blockEntity.getCount() < 12) {
            int hatchingCycles = HatcheryBlock.getHatchingCycles(blockEntity.getEntityType());
            if ((Integer)blockState.method_11654((class_2769)STAGE) < hatchingCycles) {
                serverLevel.method_8652(blockPos, (class_2680)blockState.method_28493((class_2769)STAGE), 3);
            } else {
                blockEntity.addFish(blockEntity.getEntityType(), 1);
                serverLevel.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }

    public static int getHatchingCycles(class_1299<?> entityType) {
        if (entityType.method_20210(ModRegistry.COMMON_FISHES_ENTITY_TYPE_TAG)) {
            return 3;
        }
        if (entityType.method_20210(ModRegistry.UNCOMMON_FISHES_ENTITY_TYPE_TAG)) {
            return 5;
        }
        if (entityType.method_20210(ModRegistry.RARE_FISHES_ENTITY_TYPE_TAG)) {
            return 7;
        }
        return 5;
    }

    protected class_1269 method_55765(class_1799 itemInHand, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 hitResult) {
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof HatcheryBlockEntity) {
            HatcheryBlockEntity blockEntity = (HatcheryBlockEntity)class_25862;
            if (itemInHand.method_31574(class_1802.field_8705)) {
                class_1792 item;
                if (!blockEntity.isEmpty() && (item = bucketableMobs.get(blockEntity.getEntityType())) != null) {
                    class_1799 itemStack = new class_1799((class_1935)item);
                    class_1799 resultItemStack = class_5328.method_30012((class_1799)itemInHand, (class_1657)player, (class_1799)itemStack);
                    if (!level.method_8608()) {
                        level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(0)), 3);
                        blockEntity.removeFish(1, false);
                        class_174.field_1208.method_8932((class_3222)player, itemStack);
                        player.method_5783(class_3417.field_14568, 1.0f, 1.0f);
                    }
                    player.method_6122(interactionHand, resultItemStack);
                    return class_1269.field_5812.method_61393(resultItemStack);
                }
            } else {
                class_1792 item = itemInHand.method_7909();
                if (item instanceof class_1785) {
                    class_1785 item2 = (class_1785)item;
                    if (blockEntity.getCount() < 12 && (blockEntity.getEntityType() == null || blockEntity.getEntityType() == item2.field_7991)) {
                        class_1799 itemStack = (Boolean)blockState.method_11654((class_2769)WATERLOGGED) != false ? new class_1799((class_1935)class_1802.field_8705) : new class_1799((class_1935)class_1802.field_8550);
                        class_1799 resultItemStack = class_5328.method_30012((class_1799)itemInHand, (class_1657)player, (class_1799)itemStack);
                        if (!level.method_8608()) {
                            if (!((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                                class_3610 fluidState = class_3612.field_15910.method_15729(false);
                                level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
                                level.method_64312(blockPos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)level));
                            }
                            class_174.field_1208.method_8932((class_3222)player, resultItemStack);
                            player.method_5783(class_3417.field_14568, 1.0f, 1.0f);
                            blockEntity.addFish(item2.field_7991, 1);
                        }
                        player.method_6122(interactionHand, resultItemStack);
                        return class_1269.field_5812.method_61393(resultItemStack);
                    }
                    return class_1269.field_21466;
                }
            }
        } else {
            return class_1269.field_5811;
        }
        return super.method_55765(itemInHand, blockState, level, blockPos, player, interactionHand, hitResult);
    }

    public class_2591<? extends HatcheryBlockEntity> getBlockEntityType() {
        return (class_2591)ModBlocks.HATCHERY_BLOCK_ENTITY_TYPE.comp_349();
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2350 direction) {
        int n;
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof HatcheryBlockEntity) {
            HatcheryBlockEntity blockEntity = (HatcheryBlockEntity)class_25862;
            n = blockEntity.getCount();
        } else {
            n = 0;
        }
        return n;
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, STAGE});
    }
}

