/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.sealife.SeaLife;
import fuzs.sealife.client.renderer.ModRenderType;
import fuzs.sealife.client.renderer.blockentity.state.FishTrapRenderState;
import fuzs.sealife.init.ModRegistry;
import fuzs.sealife.world.level.block.entity.FishTrapBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class FishTrapRenderer
implements BlockEntityRenderer<FishTrapBlockEntity, FishTrapRenderState> {
    public static final RenderType RENDER_TYPE = ModRenderType.text(Sheets.GUI_SHEET);
    private static final Material SPEECH_BUBBLE_TEXTURE = new Material(Sheets.GUI_SHEET, SeaLife.id("speech_bubble"));
    private final RandomSource random = RandomSource.create();
    private final ItemModelResolver itemModelResolver;
    private final MaterialSet materials;

    public FishTrapRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
        this.materials = context.materials();
    }

    public FishTrapRenderState createRenderState() {
        return new FishTrapRenderState();
    }

    public void extractRenderState(FishTrapBlockEntity blockEntity, FishTrapRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        ItemStack itemStack = blockEntity.getItem(0);
        int position = (int)blockEntity.getBlockPos().asLong();
        this.itemModelResolver.updateForTopItem(renderState.item, itemStack, ItemDisplayContext.GUI, blockEntity.getLevel(), null, position);
        renderState.cluster.item.clear();
        renderState.spin = blockEntity.getSpin(partialTick);
        renderState.isBait = itemStack.is(ModRegistry.FISHING_BAIT_ITEM_TAG);
        LocalPlayer entity = Minecraft.getInstance().player;
        if (entity != null) {
            renderState.cluster.extractItemGroupRenderState((Entity)entity, itemStack, this.itemModelResolver);
        }
    }

    public void submit(FishTrapRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        if (!renderState.cluster.item.isEmpty()) {
            this.submitItem(renderState, poseStack, nodeCollector);
            if (!renderState.isBait) {
                this.submitSpeechBubble(renderState, poseStack, nodeCollector, cameraRenderState);
            }
        }
    }

    private void submitItem(FishTrapRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.4f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.spin));
        ItemEntityRenderer.renderMultipleFromCount((PoseStack)poseStack, (SubmitNodeCollector)nodeCollector, (int)renderState.lightCoords, (ItemClusterRenderState)renderState.cluster, (RandomSource)this.random);
        poseStack.popPose();
    }

    private void submitSpeechBubble(FishTrapRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.5f, 0.5f);
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.mulPose((Quaternionfc)cameraRenderState.orientation);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        poseStack.scale(0.75f, 0.75f, 0.01f);
        renderState.item.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.translate(0.0f, -0.05f, 0.175f);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        nodeCollector.submitCustomGeometry(poseStack, RENDER_TYPE, (pose, vertexConsumer) -> {
            Matrix4f matrix4f = pose.pose();
            TextureAtlasSprite sprite = this.materials.get(SPEECH_BUBBLE_TEXTURE);
            vertexConsumer.addVertex(matrix4f, -0.5f, -0.5f, 0.0f).setUv(sprite.getU0(), sprite.getV0()).setColor(-1).setLight(renderState.lightCoords);
            vertexConsumer.addVertex(matrix4f, -0.5f, 0.5f, 0.0f).setUv(sprite.getU0(), sprite.getV1()).setColor(-1).setLight(renderState.lightCoords);
            vertexConsumer.addVertex(matrix4f, 0.5f, 0.5f, 0.0f).setUv(sprite.getU1(), sprite.getV1()).setColor(-1).setLight(renderState.lightCoords);
            vertexConsumer.addVertex(matrix4f, 0.5f, -0.5f, 0.0f).setUv(sprite.getU1(), sprite.getV0()).setColor(-1).setLight(renderState.lightCoords);
        });
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public int getViewDistance() {
        return 32;
    }
}

