/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.sealife.client.renderer.blockentity.state.HatcheryRenderState;
import fuzs.sealife.world.level.block.entity.HatcheryBlockEntity;
import fuzs.sealife.world.level.block.entity.HatcheryRenderData;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class HatcheryRenderer
implements BlockEntityRenderer<HatcheryBlockEntity, HatcheryRenderState> {
    private final EntityRenderDispatcher entityRenderer;

    public HatcheryRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.entityRenderer();
    }

    public HatcheryRenderState createRenderState() {
        return new HatcheryRenderState();
    }

    public void extractRenderState(HatcheryBlockEntity blockEntity, HatcheryRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        HatcheryRenderData renderData = blockEntity.getRenderData();
        renderState.setData(renderData.getRawData(), partialTick);
        if (renderData.getDisplayEntity() != null) {
            renderState.displayEntity = this.entityRenderer.extractEntity(renderData.getDisplayEntity(), partialTick);
            renderState.displayEntity.lightCoords = renderState.lightCoords;
        }
    }

    public void submit(HatcheryRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        EntityType entityType = renderState.displayEntity.entityType;
        if (entityType != null) {
            for (int i = 0; i < renderState.getCount(); ++i) {
                poseStack.pushPose();
                poseStack.translate(0.5, 0.6, 0.5);
                float maxBbDimension = Math.max(renderState.displayEntity.boundingBoxWidth, renderState.displayEntity.boundingBoxHeight);
                float height = renderState.getHeight(i) + 0.021f;
                if ((double)maxBbDimension > 1.0) {
                    height += 1.6f;
                }
                boolean clockwise = renderState.isClockwise(i);
                poseStack.translate(0.0, -0.25 + (0.1 + (double)(height * 0.075f)), 0.0);
                float rotation = renderState.getRotation(i);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
                poseStack.translate(0.0, (double)(-0.7f + (maxBbDimension > 1.0f ? 0.1f : 0.0f)), 0.0);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
                float scale = 0.53125f;
                poseStack.scale(scale, scale, scale);
                if ((double)maxBbDimension > 1.0) {
                    poseStack.scale(0.2f, 0.2f, 0.2f);
                } else {
                    poseStack.scale(0.5f, 0.5f, 0.5f);
                }
                poseStack.translate(1.35f, 0.0f, 1.35f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(clockwise ? -65.0f : 65.0f));
                this.entityRenderer.submit(renderState.displayEntity, cameraRenderState, 0.0, 0.0, 0.0, poseStack, nodeCollector);
                poseStack.popPose();
            }
        }
    }
}

