/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.AbstractFish;
import org.joml.Quaternionfc;

public class FishRenderer
extends MobRenderer<AbstractFish, LivingEntityRenderState, EntityModel<LivingEntityRenderState>> {
    private final ResourceLocation textureLocation;
    private final boolean panicOnLand;

    public FishRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation, Function<ModelPart, EntityModel<LivingEntityRenderState>> modelFactory) {
        this(context, modelLayerLocation, modelFactory, true);
    }

    public FishRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation, Function<ModelPart, EntityModel<LivingEntityRenderState>> modelFactory, boolean panicOnLand) {
        super(context, modelFactory.apply(context.bakeLayer(modelLayerLocation)), 0.35f);
        this.textureLocation = modelLayerLocation.model().withPath(s -> "textures/entity/fish/" + s + ".png");
        this.panicOnLand = panicOnLand;
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState renderState) {
        return this.textureLocation;
    }

    protected void setupRotations(LivingEntityRenderState renderState, PoseStack poseStack, float bodyRot, float scale) {
        float flopSpeed;
        float flopAmount;
        super.setupRotations(renderState, poseStack, bodyRot, scale);
        if (this.panicOnLand && !renderState.isInWater) {
            flopAmount = 1.3f;
            flopSpeed = 1.7f;
        } else {
            flopAmount = 1.0f;
            flopSpeed = 1.0f;
        }
        float yRot = flopAmount * 4.3f * Mth.sin((float)(flopSpeed * 0.6f * renderState.ageInTicks));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(yRot));
        poseStack.translate(0.0f, 0.0f, -0.4f);
        if (!renderState.isInWater) {
            poseStack.translate(0.2f, 0.1f, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
        }
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }
}

