/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.entity.animal;

import fuzs.sealife.world.entity.animal.FloordwellingFish;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public abstract class AbstractRay
extends FloordwellingFish {
    public AbstractRay(EntityType<? extends AbstractRay> entityType, Level level, Holder<Item> bucketItem) {
        super(entityType, level, bucketItem);
    }

    public void aiStep() {
        super.aiStep();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isAlive() && this.random.nextFloat() < this.getApplyEffectChance()) {
                for (Mob mob : this.level().getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(0.3), mobX -> Pufferfish.TARGETING_CONDITIONS.test(serverLevel, (LivingEntity)this, (LivingEntity)mobX))) {
                    if (!mob.isAlive()) continue;
                    this.touch(serverLevel, mob);
                }
            }
        }
    }

    protected abstract float getApplyEffectChance();

    protected abstract void touch(ServerLevel var1, Mob var2);
}

