/*
 * Decompiled with CFR 0.152.
 */
package fuzs.sealife.world.entity.animal;

import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ShoalingFish
extends AbstractSchoolingFish {
    private final Holder<Item> bucketItem;
    private final OptionalInt maxSchoolSize;

    public ShoalingFish(EntityType<? extends ShoalingFish> entityType, Level level, Holder<Item> bucketItem) {
        this(entityType, level, bucketItem, OptionalInt.empty());
    }

    public ShoalingFish(EntityType<? extends ShoalingFish> entityType, Level level, Holder<Item> bucketItem, OptionalInt maxSchoolSize) {
        super(entityType, level);
        this.bucketItem = bucketItem;
        this.maxSchoolSize = maxSchoolSize;
    }

    public static <T extends ShoalingFish> EntityType.EntityFactory<T> create(Supplier<Holder<Item>> bucketItemSupplier) {
        return (entityType, level) -> new ShoalingFish((EntityType<? extends ShoalingFish>)entityType, level, (Holder<Item>)((Holder)bucketItemSupplier.get()));
    }

    public static <T extends ShoalingFish> EntityType.EntityFactory<T> create(Supplier<Holder<Item>> bucketItemSupplier, int maxSchoolSize) {
        return (entityType, level) -> new ShoalingFish((EntityType<? extends ShoalingFish>)entityType, level, (Holder<Item>)((Holder)bucketItemSupplier.get()), OptionalInt.of(maxSchoolSize));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack(this.bucketItem);
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    public int getMaxSchoolSize() {
        return this.maxSchoolSize.orElseGet(() -> super.getMaxSchoolSize());
    }
}

